/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter.encoder;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.cornutum.tcases.openapi.resolver.ArrayValue;
import org.cornutum.tcases.openapi.resolver.Base64Domain;
import org.cornutum.tcases.openapi.resolver.BinaryValue;
import org.cornutum.tcases.openapi.resolver.BooleanValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DataValueVisitor;
import org.cornutum.tcases.openapi.resolver.DecimalValue;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.LongValue;
import org.cornutum.tcases.openapi.resolver.NullValue;
import org.cornutum.tcases.openapi.resolver.ObjectValue;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.openapi.testwriter.encoder.DataValueConverter;

public class DataValueJsonValue
implements DataValueConverter<JsonValue> {
    public static JsonValue toJson(DataValue<?> value) {
        return new DataValueJsonValue().convert(value);
    }

    @Override
    public JsonValue convert(DataValue<?> value) {
        return Optional.ofNullable(value).map(v -> new Visitor((DataValue<?>)v).toJson()).orElse(null);
    }

    private static class Visitor
    implements DataValueVisitor {
        private final DataValue<?> value_;
        private JsonValue json_;

        public Visitor(DataValue<?> value) {
            this.value_ = value;
        }

        public JsonValue toJson() {
            this.value_.accept(this);
            return this.json_;
        }

        @Override
        public void visit(ArrayValue<?> data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            ((List)data.getValue()).stream().forEach(item -> builder.add(DataValueJsonValue.toJson(item)));
            this.json_ = builder.build();
        }

        @Override
        public void visit(BinaryValue data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            builder.add(Base64Domain.encoded((byte[])data.getValue()));
            this.json_ = (JsonValue)builder.build().get(0);
        }

        @Override
        public void visit(BooleanValue data) {
            this.json_ = ((Boolean)data.getValue()).equals(Boolean.TRUE) ? JsonValue.TRUE : JsonValue.FALSE;
        }

        @Override
        public void visit(DecimalValue data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            builder.add((BigDecimal)data.getValue());
            this.json_ = (JsonValue)builder.build().get(0);
        }

        @Override
        public void visit(IntegerValue data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            builder.add(((Integer)data.getValue()).intValue());
            this.json_ = (JsonValue)builder.build().get(0);
        }

        @Override
        public void visit(LongValue data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            builder.add(((Long)data.getValue()).longValue());
            this.json_ = (JsonValue)builder.build().get(0);
        }

        @Override
        public void visit(NullValue data) {
            this.json_ = JsonValue.NULL;
        }

        @Override
        public void visit(ObjectValue data) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            ((Map)data.getValue()).keySet().stream().forEach(key -> builder.add(key, DataValueJsonValue.toJson((DataValue)((Map)data.getValue()).get(key))));
            this.json_ = builder.build();
        }

        @Override
        public void visit(StringValue data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            builder.add((String)data.getValue());
            this.json_ = (JsonValue)builder.build().get(0);
        }
    }
}

