/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cornutum.tcases.openapi.resolver.ParamData;
import org.cornutum.tcases.openapi.resolver.ParamDef;
import org.cornutum.tcases.openapi.testwriter.TestWriterException;
import org.cornutum.tcases.openapi.testwriter.encoder.FormParameterEncoder;
import org.cornutum.tcases.openapi.testwriter.encoder.LabelValueEncoder;
import org.cornutum.tcases.openapi.testwriter.encoder.MatrixValueEncoder;
import org.cornutum.tcases.openapi.testwriter.encoder.SimpleValueEncoder;
import org.cornutum.tcases.openapi.testwriter.encoder.UriEncoder;

public final class TestWriterUtils {
    private static final Pattern literalEscaped_ = Pattern.compile("[\\\\\"]");

    private TestWriterUtils() {
    }

    public static List<Map.Entry<String, String>> getQueryParameters(ParamData param) {
        return TestWriterUtils.getQueryParameters(param, false);
    }

    public static List<Map.Entry<String, String>> getQueryParameters(ParamData param, boolean uriEncoded) {
        try {
            if (!param.getLocation().equals((Object)ParamDef.Location.QUERY)) {
                throw new TestWriterException(String.format("%s is not a %s parameter", new Object[]{param, ParamDef.Location.QUERY}));
            }
            UriEncoder.Component component = uriEncoded ? UriEncoder.Component.QUERY : UriEncoder.Component.NONE;
            return FormParameterEncoder.encode(param, component);
        }
        catch (Exception e) {
            throw new TestWriterException(String.format("%s: can't get query parameter values", param), e);
        }
    }

    public static String getPathParameterValue(ParamData param) {
        return TestWriterUtils.getPathParameterValue(param, false);
    }

    public static String getPathParameterValue(ParamData param, boolean uriEncoded) {
        try {
            UriEncoder.Component component;
            if (!param.getLocation().equals((Object)ParamDef.Location.PATH)) {
                throw new TestWriterException(String.format("%s is not a %s parameter", new Object[]{param, ParamDef.Location.PATH}));
            }
            String style = param.getStyle();
            UriEncoder.Component component2 = component = uriEncoded ? UriEncoder.Component.PATH : UriEncoder.Component.NONE;
            return "label".equals(style) ? LabelValueEncoder.encode(param, component) : ("matrix".equals(style) ? MatrixValueEncoder.encode(param, component) : SimpleValueEncoder.encode(param, component));
        }
        catch (Exception e) {
            throw new TestWriterException(String.format("%s: can't get path parameter value", param), e);
        }
    }

    public static Optional<String> getHeaderParameterValue(ParamData param) {
        try {
            if (!param.getLocation().equals((Object)ParamDef.Location.HEADER)) {
                throw new TestWriterException(String.format("%s is not a %s parameter", new Object[]{param, ParamDef.Location.HEADER}));
            }
            return Optional.of(param.getStyle()).filter(style -> "simple".equals(style)).map(style -> Optional.ofNullable(param.getValue()).map(v -> TestWriterUtils.quoted(SimpleValueEncoder.encode(param, UriEncoder.Component.NONE)))).orElseThrow(() -> new IllegalStateException(String.format("style=%s is not applicable for a HEADER parameter", param.getStyle())));
        }
        catch (Exception e) {
            throw new TestWriterException(String.format("%s: can't get header parameter value", param), e);
        }
    }

    public static List<Map.Entry<String, String>> getCookieParameters(ParamData param) {
        try {
            if (!param.getLocation().equals((Object)ParamDef.Location.COOKIE)) {
                throw new TestWriterException(String.format("%s is not a %s parameter", new Object[]{param, ParamDef.Location.COOKIE}));
            }
            return FormParameterEncoder.encode(param, UriEncoder.Component.NONE);
        }
        catch (Exception e) {
            throw new TestWriterException(String.format("%s: can't get cookie parameter values", param), e);
        }
    }

    public static String stringLiteral(Object value) {
        String literal = null;
        if (value != null) {
            Matcher escapeMatcher = literalEscaped_.matcher(Objects.toString(value, ""));
            StringBuffer escaped = new StringBuffer();
            while (escapeMatcher.find()) {
                escapeMatcher.appendReplacement(escaped, String.format("\\\\%s", Matcher.quoteReplacement(escapeMatcher.group())));
            }
            escapeMatcher.appendTail(escaped);
            literal = String.format("\"%s\"", escaped.toString());
        }
        return literal;
    }

    private static String quoted(String value) {
        return !value.isEmpty() && (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(value.length() - 1))) ? String.format("\"%s\"", value) : value;
    }
}

