/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.cornutum.tcases.io.IndentedWriter;
import org.cornutum.tcases.openapi.resolver.RequestCase;
import org.cornutum.tcases.openapi.testwriter.TestCaseWriter;
import org.cornutum.tcases.openapi.testwriter.TestSource;
import org.cornutum.tcases.openapi.testwriter.TestTarget;
import org.cornutum.tcases.openapi.testwriter.TestWriterException;
import org.cornutum.tcases.util.ToString;

public abstract class TestWriter<S extends TestSource, T extends TestTarget> {
    private final TestCaseWriter testCaseWriter_;

    protected TestWriter(TestCaseWriter testCaseWriter) {
        this.testCaseWriter_ = testCaseWriter;
    }

    public void writeTest(S source, T target) {
        String testName = this.getTestName(source, target);
        File targetFile = this.getTargetFile(target, testName);
        File targetDir = Optional.ofNullable(targetFile).flatMap(file -> Optional.ofNullable(file.getParentFile())).map(File::getAbsoluteFile).orElse(null);
        if (targetDir != null && !targetDir.exists() && !targetDir.mkdirs()) {
            throw new TestWriterException(String.format("Can't create targetDir=%s", targetDir));
        }
        FileOutputStream fileStream = null;
        IndentedWriter targetWriter = null;
        try {
            fileStream = targetFile == null ? null : new FileOutputStream(targetFile);
            OutputStream targetStream = Optional.ofNullable(fileStream).orElse((FileOutputStream)Optional.ofNullable(((TestTarget)target).getOutput()).orElse(System.out));
            targetWriter = new IndentedWriter(targetStream);
            targetWriter.setIndent(4);
            this.writeProlog(target, testName, targetWriter);
            this.writeTestCases(target, testName, ((TestSource)source).getRequestCases(), targetWriter);
            this.writeEpilog(target, testName, targetWriter);
        }
        catch (Exception e) {
            throw new TestWriterException(String.format("Can't write test=%s", testName), e);
        }
        finally {
            if (targetWriter != null) {
                targetWriter.flush();
            }
            IOUtils.closeQuietly((Closeable)fileStream, null);
        }
    }

    public File getTestFile(S source, T target) {
        return this.getTargetFile(target, this.getTestName(source, target));
    }

    public String getTestName(S source, T target) {
        return this.getTestName(Optional.ofNullable(this.getTestBaseName(source, target)).orElseThrow(() -> new TestWriterException(String.format("No test name defined by source=%s, target=%s", source, target))));
    }

    protected abstract String getTestName(String var1);

    protected String getTestBaseName(S source, T target) {
        return Optional.ofNullable(((TestTarget)target).getName()).orElse(Optional.ofNullable(((TestTarget)target).getFile()).map(file -> FilenameUtils.getBaseName((String)file.getName())).orElse(((TestSource)source).getApi()));
    }

    protected File getTargetFile(T target, String testName) {
        File targetFile = ((TestTarget)target).getFile();
        File targetDir = ((TestTarget)target).getDir();
        return targetFile == null && targetDir == null ? null : (targetDir == null ? targetFile : (targetFile == null ? new File(targetDir, testName.replaceAll("[/<>|:& \\\\]+", "-")) : (targetFile.isAbsolute() ? targetFile : new File(targetDir, targetFile.getPath()))));
    }

    protected void writeProlog(T target, String testName, IndentedWriter targetWriter) {
        this.writeOpening(target, testName, targetWriter);
        this.writeDependencies(target, testName, targetWriter);
        this.getTestCaseWriter().writeDependencies(testName, targetWriter);
        this.writeDeclarations(target, testName, targetWriter);
        this.getTestCaseWriter().writeDeclarations(testName, targetWriter);
    }

    protected abstract void writeOpening(T var1, String var2, IndentedWriter var3);

    protected abstract void writeDependencies(T var1, String var2, IndentedWriter var3);

    protected abstract void writeDeclarations(T var1, String var2, IndentedWriter var3);

    protected void writeTestCases(T target, String testName, List<RequestCase> requestCases, IndentedWriter targetWriter) {
        requestCases.stream().forEach(requestCase -> this.writeTestCase(target, testName, (RequestCase)requestCase, targetWriter));
    }

    protected void writeTestCase(T target, String testName, RequestCase requestCase, IndentedWriter targetWriter) {
        this.getTestCaseWriter().writeTestCase(testName, this.getTestServer(requestCase), requestCase, targetWriter);
    }

    protected void writeEpilog(T target, String testName, IndentedWriter targetWriter) {
        this.getTestCaseWriter().writeClosing(testName, targetWriter);
        this.writeClosing(target, testName, targetWriter);
    }

    protected abstract void writeClosing(T var1, String var2, IndentedWriter var3);

    protected TestCaseWriter getTestCaseWriter() {
        return this.testCaseWriter_;
    }

    protected URI getTestServer(RequestCase requestCase) {
        return null;
    }

    public String toString() {
        return ToString.getBuilder((Object)this).toString();
    }
}

