/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter;

import java.io.File;
import java.io.OutputStream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cornutum.tcases.util.ToString;

public class TestTarget {
    private OutputStream output_;
    private String name_;
    private File file_;
    private File dir_;
    private Long timeout_;

    public void setOutput(OutputStream output) {
        this.output_ = output;
    }

    public OutputStream getOutput() {
        return this.output_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public void setFile(File file) {
        this.file_ = file;
    }

    public void setFile(String file) {
        this.setFile(new File(file));
    }

    public File getFile() {
        return this.file_;
    }

    public void setDir(File dir) {
        this.dir_ = dir;
    }

    public File getDir() {
        return this.dir_;
    }

    public void setTimeout(Long millis) {
        this.timeout_ = millis;
    }

    public Long getTimeout() {
        return this.timeout_;
    }

    public String toString() {
        ToStringBuilder builder = ToString.getBuilder((Object)this);
        if (this.getName() != null) {
            builder.append("name", (Object)this.getName());
        }
        if (this.getFile() != null && this.getDir() != null) {
            builder.append("file", (Object)this.getFile().getName()).append("dir", (Object)this.getDir());
        } else if (this.getFile() != null) {
            builder.append("file", (Object)this.getFile());
        } else if (this.getDir() != null) {
            builder.append("dir", (Object)this.getDir());
        } else if (this.getOutput() != null) {
            builder.append((Object)this.getOutput().getClass().getSimpleName());
        } else {
            builder.append((Object)"STDOUT");
        }
        if (this.getTimeout() != null) {
            builder.append("timeout", (Object)this.getTimeout());
        }
        return builder.toString();
    }

    public static Builder basic() {
        return new Builder();
    }

    public static abstract class BaseBuilder<T extends BaseBuilder<T>> {
        protected abstract TestTarget getTestTarget();

        public T named(String name) {
            this.getTestTarget().setName(name);
            return (T)this;
        }

        public T toStream(OutputStream output) {
            this.getTestTarget().setOutput(output);
            return (T)this;
        }

        public T toFile(String file) {
            this.getTestTarget().setFile(file);
            return (T)this;
        }

        public T toFile(File file) {
            this.getTestTarget().setFile(file);
            return (T)this;
        }

        public T inDir(File dir) {
            this.getTestTarget().setDir(dir);
            return (T)this;
        }

        public T timeout(Long timeout) {
            this.getTestTarget().setTimeout(timeout);
            return (T)this;
        }
    }

    public static class Builder
    extends BaseBuilder<Builder> {
        private TestTarget target_ = new TestTarget();

        private Builder() {
        }

        @Override
        protected TestTarget getTestTarget() {
            return this.target_;
        }

        public TestTarget build() {
            return this.target_;
        }
    }
}

