/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cornutum.tcases.openapi.resolver.RequestCase;
import org.cornutum.tcases.openapi.resolver.RequestTestDef;
import org.cornutum.tcases.util.CollectionUtils;
import org.cornutum.tcases.util.ToString;

public class TestSource {
    private RequestTestDef testDef_;
    private Set<String> paths_;
    private Set<String> ops_;

    public TestSource(RequestTestDef testDef) {
        this.testDef_ = testDef;
    }

    public RequestTestDef getTestDef() {
        return this.testDef_;
    }

    public String getApi() {
        return this.getTestDef().getApi();
    }

    public void setPaths(Iterable<String> paths) {
        this.paths_ = Optional.ofNullable(CollectionUtils.toStream(paths)).map(s -> s.collect(Collectors.toSet())).orElse(null);
    }

    public void setPaths(String ... paths) {
        this.setPaths(paths.length == 0 ? null : Arrays.asList(paths));
    }

    public Set<String> getPaths() {
        return Optional.ofNullable(this.paths_).map(Collections::unmodifiableSet).orElse(null);
    }

    public void setOperations(Iterable<String> operations) {
        this.ops_ = Optional.ofNullable(CollectionUtils.toStream(operations)).map(s -> s.collect(Collectors.toSet())).orElse(null);
    }

    public void setOperations(String ... operations) {
        this.setOperations(operations.length == 0 ? null : Arrays.asList(operations));
    }

    public Set<String> getOperations() {
        return Optional.ofNullable(this.ops_).map(Collections::unmodifiableSet).orElse(null);
    }

    public List<RequestCase> getRequestCases() {
        return this.getTestDef().getRequestCases(this.getPaths(), this.getOperations());
    }

    public String toString() {
        ToStringBuilder builder = ToString.getBuilder((Object)this);
        builder.append((Object)this.getTestDef());
        Optional.ofNullable(this.getOperations()).ifPresent(ops -> builder.append(ops));
        Optional.ofNullable(this.getPaths()).ifPresent(paths -> builder.append(paths));
        return builder.toString();
    }

    public static Builder from(RequestTestDef testDef) {
        return new Builder(testDef);
    }

    public static class Builder {
        private TestSource source_;

        private Builder(RequestTestDef testDef) {
            this.source_ = new TestSource(testDef);
        }

        public Builder paths(String ... paths) {
            this.source_.setPaths(paths);
            return this;
        }

        public Builder operations(String ... operations) {
            this.source_.setOperations(operations);
            return this;
        }

        public TestSource build() {
            return this.source_;
        }
    }
}

