/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cornutum.tcases.openapi.testwriter.TestCaseWriter;
import org.cornutum.tcases.openapi.testwriter.encoder.DataValueConverter;
import org.cornutum.tcases.openapi.testwriter.encoder.DataValueJson;
import org.cornutum.tcases.openapi.testwriter.encoder.DataValueText;
import org.cornutum.tcases.util.MapBuilder;
import org.cornutum.tcases.util.ToString;

public abstract class TestCaseContentWriter
implements TestCaseWriter {
    private Map<String, DataValueConverter<String>> converters_ = new HashMap<String, DataValueConverter<String>>();

    protected TestCaseContentWriter() {
        this.getDefaultConverters().forEach((mediaType, converter) -> this.setConverter((String)mediaType, (DataValueConverter<String>)converter));
    }

    protected Map<String, DataValueConverter<String>> getDefaultConverters() {
        DataValueText textPlain = new DataValueText();
        return new MapBuilder().put((Object)"*/*", (Object)textPlain).put((Object)"text/*", (Object)textPlain).put((Object)"text/plain", (Object)textPlain).put((Object)"application/json", (Object)new DataValueJson()).put((Object)"application/*+json", (Object)new DataValueJson()).build();
    }

    public void setConverter(String mediaType, DataValueConverter<String> converter) {
        if (converter == null) {
            this.converters_.remove(this.validMediaType(mediaType));
        } else {
            this.converters_.put(this.validMediaType(mediaType), converter);
        }
    }

    public Optional<DataValueConverter<String>> getConverter(String mediaType) {
        MediaRange mediaRange = MediaRange.of(mediaType);
        ArrayList<String> alternatives = new ArrayList<String>();
        alternatives.add(mediaRange.toString());
        Optional.ofNullable(mediaRange.suffix()).ifPresent(suffix -> {
            alternatives.add(String.format("%s/%s+%s", mediaRange.type(), mediaRange.subtype(), mediaRange.suffix()));
            alternatives.add(String.format("%s/*+%s", mediaRange.type(), mediaRange.suffix()));
        });
        alternatives.add(String.format("%s/%s", mediaRange.type(), mediaRange.subtype()));
        alternatives.add(String.format("%s/*", mediaRange.type()));
        alternatives.add("*/*");
        return alternatives.stream().filter(alternative -> this.converters_.containsKey(alternative)).map(alternative -> this.converters_.get(alternative)).findFirst();
    }

    private String validMediaType(String mediaType) {
        return mediaType == null ? "*/*" : MediaRange.of(mediaType).toString();
    }

    public String toString() {
        return ToString.getBuilder((Object)this).build();
    }

    public static class MediaRange {
        private final String type_;
        private final String subtype_;
        private final String suffix_;
        private final String parameter_;
        private static final Pattern mediaRange_ = Pattern.compile("([^\\s/]+)/([^\\s+;]+)(?:\\+([^\\s;]+))?((?:;[^\\s;=]+=[^\\s;=]+)+)?");

        public static MediaRange of(String text) {
            return new MediaRange(text);
        }

        private MediaRange(String text) {
            Matcher matcher = Optional.of(mediaRange_.matcher(text)).filter(Matcher::matches).orElseThrow(() -> new IllegalArgumentException(String.format("'%s' is not a valid media range", text)));
            this.type_ = matcher.group(1);
            this.subtype_ = matcher.group(2);
            this.suffix_ = matcher.group(3);
            this.parameter_ = matcher.group(4);
        }

        public String type() {
            return this.type_;
        }

        public String subtype() {
            return this.subtype_;
        }

        public String suffix() {
            return this.suffix_;
        }

        public String parameter() {
            return this.parameter_;
        }

        public String toString() {
            return String.format("%s/%s%s%s", this.type_, this.subtype_, Optional.ofNullable(this.suffix_).map(suffix -> String.format("+%s", suffix)).orElse(""), Optional.ofNullable(this.parameter_).orElse(""));
        }
    }
}

