/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter;

import java.io.File;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.cornutum.tcases.io.IndentedWriter;
import org.cornutum.tcases.openapi.testwriter.JavaTestTarget;
import org.cornutum.tcases.openapi.testwriter.TestCaseWriter;
import org.cornutum.tcases.openapi.testwriter.TestSource;
import org.cornutum.tcases.openapi.testwriter.TestWriter;
import org.cornutum.tcases.openapi.testwriter.TestWriterException;

public abstract class JavaTestWriter
extends TestWriter<TestSource, JavaTestTarget> {
    protected JavaTestWriter(TestCaseWriter testCaseWriter) {
        super(testCaseWriter);
    }

    @Override
    protected String getTestName(String baseName) {
        String[] words = baseName.split("\\W+");
        return IntStream.range(0, words.length).mapToObj(i -> i == 0 ? WordUtils.capitalize((String)words[i]) : WordUtils.capitalizeFully((String)words[i])).collect(Collectors.joining(""));
    }

    protected abstract String getClassName(String var1);

    @Override
    protected void writeOpening(JavaTestTarget target, String testName, IndentedWriter targetWriter) {
        targetWriter.println(String.format("package %s;", Optional.ofNullable(target.getTargetPackage()).orElseThrow(() -> new TestWriterException(String.format("No package defined for target=%s", target)))));
    }

    @Override
    protected void writeDependencies(JavaTestTarget target, String testName, IndentedWriter targetWriter) {
        targetWriter.println();
        Optional.ofNullable(target.getBaseClassPackage()).filter(basePkg -> !basePkg.equals(target.getTargetPackage())).ifPresent(basePkg -> targetWriter.println(String.format("import %s", target.getBaseClass())));
    }

    @Override
    protected void writeDeclarations(JavaTestTarget target, String testName, IndentedWriter targetWriter) {
        StringBuilder classDecl = new StringBuilder().append("public class ").append(this.getClassName(testName));
        Optional.ofNullable(target.getBaseClassName()).ifPresent(baseClass -> classDecl.append(" extends ").append((String)baseClass));
        classDecl.append(" {");
        targetWriter.println();
        targetWriter.println(classDecl.toString());
        targetWriter.indent();
    }

    @Override
    protected void writeClosing(JavaTestTarget target, String testName, IndentedWriter targetWriter) {
        targetWriter.unindent();
        targetWriter.println("}");
    }

    @Override
    protected File getTargetFile(JavaTestTarget target, String testName) {
        File targetFile = super.getTargetFile(target, testName);
        return targetFile != null && StringUtils.isBlank((CharSequence)FilenameUtils.getExtension((String)targetFile.getName())) ? new File(targetFile.getParentFile(), String.format("%s.java", FilenameUtils.getBaseName((String)targetFile.getName()))) : targetFile;
    }
}

