/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.openapi.testwriter.TestTarget;
import org.cornutum.tcases.util.ToString;

public class JavaTestTarget
extends TestTarget {
    private String package_;
    private String baseClass_;

    public void setPackage(String packageName) {
        this.package_ = packageName;
    }

    public void setPackage(Class<?> packageMember) {
        this.setPackage((String)Optional.ofNullable(packageMember).map(Class::getPackage).map(Package::getName).orElse(null));
    }

    public String getPackage() {
        return this.package_;
    }

    public void setBaseClass(String baseClassName) {
        this.baseClass_ = baseClassName;
    }

    public void setBaseClass(Class<?> baseClass) {
        this.setBaseClass(baseClass == null ? null : baseClass.getName());
    }

    public String getBaseClass() {
        return this.baseClass_;
    }

    public String getBaseClassName() {
        return Optional.ofNullable(this.getBaseClass()).map(fqn -> fqn.lastIndexOf(".")).filter(packageEnd -> packageEnd >= 0).map(packageEnd -> this.getBaseClass().substring(packageEnd + 1)).orElse(this.getBaseClass());
    }

    public String getBaseClassPackage() {
        return Optional.ofNullable(this.getBaseClass()).map(fqn -> fqn.lastIndexOf(".")).filter(packageEnd -> packageEnd >= 0).map(packageEnd -> this.getBaseClass().substring(0, (int)packageEnd)).orElse(null);
    }

    public String getTargetPackage() {
        return Optional.ofNullable(this.getPackage()).orElseGet(this::getDefaultPackage);
    }

    private String getDefaultPackage() {
        File targetDir = Optional.ofNullable(this.getDir()).orElse(Optional.ofNullable(this.getFile()).map(File::getParentFile).orElse(null));
        return Optional.ofNullable(targetDir).map(File::getAbsoluteFile).flatMap(this::getMavenPackage).orElse(null);
    }

    private Optional<String> getMavenPackage(File dir) {
        List<String> dirs = this.getPathElements(dir);
        int root = dirs.indexOf("java");
        return root >= 0 ? Optional.ofNullable(StringUtils.trimToNull((String)dirs.subList(root + 1, dirs.size()).stream().collect(Collectors.joining(".")))) : Optional.empty();
    }

    private List<String> getPathElements(File file) {
        List elements = Optional.ofNullable(file.getParentFile()).map(this::getPathElements).orElseGet(ArrayList::new);
        elements.add(file.getName());
        return elements;
    }

    @Override
    public String toString() {
        return ToString.getBuilder((Object)this).append("package", (Object)StringUtils.abbreviateMiddle((String)this.getPackage(), (String)"...", (int)20)).appendSuper(super.toString()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends TestTarget.BaseBuilder<Builder> {
        private JavaTestTarget target_ = new JavaTestTarget();

        private Builder() {
        }

        @Override
        protected TestTarget getTestTarget() {
            return this.target_;
        }

        public Builder inPackage(Class<?> packageMember) {
            this.target_.setPackage(packageMember);
            return this;
        }

        public Builder inPackage(String packageName) {
            this.target_.setPackage(packageName);
            return this;
        }

        public Builder extending(String baseClass) {
            this.target_.setBaseClass(baseClass);
            return this;
        }

        public Builder extending(Class<?> baseClass) {
            this.target_.setBaseClass(baseClass);
            return this;
        }

        public JavaTestTarget build() {
            return this.target_;
        }
    }
}

