/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.testwriter;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.io.IndentedWriter;
import org.cornutum.tcases.openapi.resolver.RequestCase;
import org.cornutum.tcases.openapi.testwriter.JavaTestTarget;
import org.cornutum.tcases.openapi.testwriter.JavaTestWriter;
import org.cornutum.tcases.openapi.testwriter.TestCaseWriter;
import org.cornutum.tcases.util.CollectionUtils;

public abstract class AnnotatedJavaTestWriter
extends JavaTestWriter {
    private static final Pattern uriSegmentPattern_ = Pattern.compile("([^{}]+)|\\{([^}]+)\\}");
    private static final Pattern varBindingPattern_ = Pattern.compile("([\\w\\-.]+)=([^\\&]+)");

    protected AnnotatedJavaTestWriter(TestCaseWriter testCaseWriter) {
        super(testCaseWriter);
    }

    protected abstract void writeTestAnnotationDependencies(JavaTestTarget var1, String var2, IndentedWriter var3);

    protected abstract void writeTestAnnotation(JavaTestTarget var1, String var2, RequestCase var3, IndentedWriter var4);

    @Override
    protected void writeDependencies(JavaTestTarget target, String testName, IndentedWriter targetWriter) {
        super.writeDependencies(target, testName, targetWriter);
        targetWriter.println();
        this.writeTestAnnotationDependencies(target, testName, targetWriter);
    }

    @Override
    protected void writeTestCase(JavaTestTarget target, String testName, RequestCase requestCase, IndentedWriter targetWriter) {
        targetWriter.println();
        this.writeTestAnnotation(target, testName, requestCase, targetWriter);
        targetWriter.println(String.format("public void %s() {", this.getMethodName(requestCase)));
        targetWriter.indent();
        super.writeTestCase(target, testName, requestCase, targetWriter);
        targetWriter.unindent();
        targetWriter.println("}");
    }

    @Override
    protected File getTargetFile(JavaTestTarget target, String testName) {
        File targetFile = super.getTargetFile(target, testName);
        return targetFile != null && "java".equals(FilenameUtils.getExtension((String)targetFile.getName())) ? new File(targetFile.getParentFile(), String.format("%s.java", this.getClassName(FilenameUtils.getBaseName((String)targetFile.getName())))) : targetFile;
    }

    @Override
    protected String getClassName(String testName) {
        boolean isStandardTestClass = testName.startsWith("Test") || testName.endsWith("Test") || testName.endsWith("Tests") || testName.endsWith("TestCase");
        return isStandardTestClass ? testName : testName + "Test";
    }

    protected String getMethodName(RequestCase requestCase) {
        StringBuilder methodName = new StringBuilder();
        methodName.append(requestCase.getOperation().toLowerCase());
        Arrays.stream(requestCase.getPath().split("/")).forEach(segment -> {
            Matcher segmentMatcher = uriSegmentPattern_.matcher((CharSequence)segment);
            while (segmentMatcher.find()) {
                methodName.append(this.toIdentifier(segmentMatcher.group()));
            }
        });
        this.getDescriptor(requestCase).ifPresent(descriptor -> methodName.append("_").append((String)descriptor));
        return methodName.toString();
    }

    protected Optional<String> getDescriptor(RequestCase requestCase) {
        return "None.Defined='No'".equals(requestCase.getName()) ? Optional.empty() : Optional.of(this.createDescriptor(requestCase));
    }

    protected String createDescriptor(RequestCase requestCase) {
        return Optional.ofNullable(requestCase.getName()).map(name -> this.getBindingsDescriptor((String)name).orElse(this.toIdentifier((String)name))).orElse(String.valueOf(requestCase.getId()));
    }

    protected Optional<String> getBindingsDescriptor(String text) {
        Stream.Builder<String> bindings = Stream.builder();
        Matcher varBindingMatcher = varBindingPattern_.matcher(text);
        while (varBindingMatcher.find()) {
            String varId = this.toIdentifier(StringUtils.removeEnd((String)varBindingMatcher.group(1), (String)".Is"));
            String[] value = (String[])CollectionUtils.fromCsv((String)varBindingMatcher.group(2)).toArray(String[]::new);
            String valueId = value.length == 0 ? "Empty" : (value[0] == null ? "Null" : (StringUtils.isBlank((CharSequence)value[0]) ? "Blank" : this.toIdentifier(DefUtils.toNumberIdentifiers((String)value[0]).replaceAll(" *<= *", "Leq_").replaceAll(" *< *", "Lt_").replaceAll(" *>= *", "Geq_").replaceAll(" *> *", "Gt_"))));
            bindings.add(String.format("%s_Is_%s", varId, valueId));
        }
        String descriptor = bindings.build().collect(Collectors.joining("_"));
        return descriptor.isEmpty() ? Optional.empty() : Optional.of(descriptor);
    }

    protected String toIdentifier(String text) {
        return Arrays.stream(text.trim().split("\\W+")).map(id -> WordUtils.capitalize((String)id)).collect(Collectors.joining(""));
    }
}

