/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver.io;

import java.io.Closeable;
import java.io.InputStream;
import javax.json.JsonArray;
import javax.json.JsonReader;
import org.apache.commons.io.IOUtils;
import org.cornutum.tcases.openapi.resolver.RequestCaseException;
import org.cornutum.tcases.openapi.resolver.RequestTestDef;
import org.cornutum.tcases.openapi.resolver.io.RequestCaseJson;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonValidationService;
import org.leadpony.justify.api.ProblemHandler;

public class RequestTestDefReader
implements Closeable {
    private InputStream stream_;

    public RequestTestDefReader() {
        this(null);
    }

    public RequestTestDefReader(InputStream stream) {
        this.setInputStream(stream);
    }

    public RequestTestDef getRequestTestDef() {
        JsonValidationService service = JsonValidationService.newInstance();
        JsonSchema schema = service.readSchema(this.getClass().getResourceAsStream("/schema/request-cases-schema.json"));
        ProblemHandler handler = ProblemHandler.throwing();
        try (JsonReader reader = service.createReader(this.stream_, schema, handler);){
            JsonArray json;
            try {
                json = reader.readArray();
            }
            catch (Exception e) {
                throw new RequestCaseException("Invalid request case definition", (Throwable)e);
            }
            RequestTestDef requestTestDef = new RequestTestDef(RequestCaseJson.asRequestCases(json));
            return requestTestDef;
        }
    }

    public void setInputStream(InputStream stream) {
        this.stream_ = stream == null ? System.in : stream;
    }

    protected InputStream getInputStream() {
        return this.stream_;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.getInputStream(), null);
    }
}

