/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver.io;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.cornutum.tcases.openapi.resolver.ApiKeyDef;
import org.cornutum.tcases.openapi.resolver.ArrayValue;
import org.cornutum.tcases.openapi.resolver.AuthDef;
import org.cornutum.tcases.openapi.resolver.AuthDefVisitor;
import org.cornutum.tcases.openapi.resolver.Base64Domain;
import org.cornutum.tcases.openapi.resolver.BinaryValue;
import org.cornutum.tcases.openapi.resolver.BooleanValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DataValueVisitor;
import org.cornutum.tcases.openapi.resolver.DateTimeValue;
import org.cornutum.tcases.openapi.resolver.DateValue;
import org.cornutum.tcases.openapi.resolver.DecimalValue;
import org.cornutum.tcases.openapi.resolver.EmailValue;
import org.cornutum.tcases.openapi.resolver.HttpBasicDef;
import org.cornutum.tcases.openapi.resolver.HttpBearerDef;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.LongValue;
import org.cornutum.tcases.openapi.resolver.MessageData;
import org.cornutum.tcases.openapi.resolver.NullValue;
import org.cornutum.tcases.openapi.resolver.ObjectValue;
import org.cornutum.tcases.openapi.resolver.ParamData;
import org.cornutum.tcases.openapi.resolver.ParamDef;
import org.cornutum.tcases.openapi.resolver.RequestCase;
import org.cornutum.tcases.openapi.resolver.RequestCaseContext;
import org.cornutum.tcases.openapi.resolver.RequestCaseException;
import org.cornutum.tcases.openapi.resolver.RequestTestDef;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.openapi.resolver.UuidValue;
import org.cornutum.tcases.util.CollectionUtils;

public final class RequestCaseJson {
    private static final String API = "api";
    private static final String AUTH = "auth";
    private static final String AUTH_FAILURE = "authFailure";
    private static final String BODY = "body";
    private static final String DATA = "data";
    private static final String EXPLODE = "explode";
    private static final String FORMAT = "format";
    private static final String ID = "id";
    private static final String IN = "in";
    private static final String INVALID_INPUT = "invalidInput";
    private static final String LOCATION = "location";
    private static final String MEDIA_TYPE = "mediaType";
    private static final String NAME = "name";
    private static final String OPERATION = "operation";
    private static final String PARAMETERS = "parameters";
    private static final String PATH = "path";
    private static final String SCHEME = "scheme";
    private static final String SERVER = "server";
    private static final String STYLE = "style";
    private static final String TYPE = "type";
    private static final String VALID = "valid";
    private static final String VALUE = "value";
    private static final String VERSION = "version";

    private RequestCaseJson() {
    }

    public static JsonArray toJson(RequestTestDef requestTestDef) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (RequestCase requestCase : requestTestDef.getRequestCases()) {
            builder.add((JsonValue)RequestCaseJson.toJson(requestCase));
        }
        return builder.build();
    }

    private static JsonObject toJson(RequestCase requestCase) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add(ID, requestCase.getId());
        Optional.ofNullable(requestCase.getName()).ifPresent(name -> builder.add(NAME, name));
        Optional.ofNullable(requestCase.getServer()).ifPresent(server -> builder.add(SERVER, server.toString()));
        Optional.ofNullable(requestCase.getVersion()).ifPresent(version -> builder.add(VERSION, version));
        Optional.ofNullable(requestCase.getApi()).ifPresent(api -> builder.add(API, api));
        Optional.ofNullable(requestCase.getPath()).ifPresent(path -> builder.add(PATH, path));
        Optional.ofNullable(requestCase.getOperation()).ifPresent(op -> builder.add(OPERATION, op));
        JsonArrayBuilder paramBuilder = Json.createArrayBuilder();
        CollectionUtils.toStream(requestCase.getParams()).forEach(paramData -> paramBuilder.add((JsonValue)RequestCaseJson.toJson(paramData)));
        JsonArray params = paramBuilder.build();
        if (!params.isEmpty()) {
            builder.add(PARAMETERS, (JsonValue)params);
        }
        Optional.ofNullable(requestCase.getBody()).ifPresent(body -> builder.add(BODY, (JsonValue)RequestCaseJson.toJson(body)));
        JsonArrayBuilder authBuilder = Json.createArrayBuilder();
        CollectionUtils.toStream(requestCase.getAuthDefs()).forEach(authDef -> authBuilder.add(AuthDefJson.toJson(authDef)));
        JsonArray authDefs = authBuilder.build();
        if (!authDefs.isEmpty()) {
            builder.add(AUTH, (JsonValue)authDefs);
        }
        Optional.ofNullable(requestCase.getInvalidInput()).ifPresent(invalidInput -> builder.add(INVALID_INPUT, invalidInput));
        if (requestCase.isAuthFailure()) {
            builder.add(AUTH_FAILURE, true);
        }
        return builder.build();
    }

    private static JsonObject toJson(ParamData paramData) {
        JsonObjectBuilder builder = Json.createObjectBuilder().add(NAME, paramData.getName()).add(IN, paramData.getLocation().toString().toLowerCase()).add(STYLE, paramData.getStyle()).add(EXPLODE, paramData.isExploded());
        return RequestCaseJson.addMessageData(builder, paramData).build();
    }

    private static JsonObject toJson(MessageData messageData) {
        return RequestCaseJson.addMessageData(Json.createObjectBuilder(), messageData).build();
    }

    private static JsonObjectBuilder addMessageData(JsonObjectBuilder builder, MessageData messageData) {
        Optional.ofNullable(messageData.getMediaType()).ifPresent(mediaType -> builder.add(MEDIA_TYPE, mediaType));
        JsonValue dataValue = Optional.ofNullable(messageData.getValue()).map(v -> RequestCaseJson.toJson(v)).orElse(JsonValue.NULL);
        builder.add(DATA, dataValue);
        builder.add(VALID, messageData.isValid());
        return builder;
    }

    private static JsonObject toJson(DataValue<?> dataValue) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add(TYPE, String.valueOf((Object)dataValue.getType()).toLowerCase());
        builder.add(VALUE, DataValueJson.toJson(dataValue));
        Optional.ofNullable(dataValue.getFormat()).ifPresent(format -> builder.add(FORMAT, format));
        return builder.build();
    }

    public static List<RequestCase> asRequestCases(JsonArray json) {
        RequestCaseContext context = new RequestCaseContext();
        return json.getValuesAs(JsonObject.class).stream().map(rcJson -> RequestCaseJson.asRequestCase(context, rcJson)).collect(Collectors.toList());
    }

    private static RequestCase asRequestCase(RequestCaseContext context, JsonObject json) {
        return context.resultFor(String.valueOf(json.get((Object)ID)), () -> {
            RequestCase requestCase = new RequestCase(json.getInt(ID));
            requestCase.setName(context.resultFor(NAME, () -> json.getString(NAME, null)));
            requestCase.setServer(context.resultFor(SERVER, () -> json.getString(SERVER, null)));
            requestCase.setVersion(context.resultFor(VERSION, () -> json.getString(VERSION, null)));
            requestCase.setApi(context.resultFor(API, () -> json.getString(API, null)));
            requestCase.setPath(context.resultFor(PATH, () -> json.getString(PATH, null)));
            requestCase.setOperation(context.resultFor(OPERATION, () -> json.getString(OPERATION, null)));
            requestCase.setInvalidInput(context.resultFor(INVALID_INPUT, () -> json.getString(INVALID_INPUT, null)));
            context.doFor(PARAMETERS, () -> Optional.ofNullable(json.getJsonArray(PARAMETERS)).map(array -> array.getValuesAs(JsonObject.class)).ifPresent(params -> params.stream().forEach(param -> requestCase.addParam(RequestCaseJson.asParamData(context, param)))));
            context.doFor(BODY, () -> Optional.ofNullable(json.getJsonObject(BODY)).ifPresent(body -> requestCase.setBody(RequestCaseJson.asMessageData(context, body))));
            context.doFor(AUTH, () -> Optional.ofNullable(json.getJsonArray(AUTH)).map(array -> array.getValuesAs(JsonObject.class)).ifPresent(authDefs -> authDefs.stream().forEach(authDef -> requestCase.addAuthDef(RequestCaseJson.asAuthDef(context, authDef)))));
            requestCase.setAuthFailure(context.resultFor(AUTH_FAILURE, () -> json.getBoolean(AUTH_FAILURE, false)));
            return requestCase;
        });
    }

    private static ParamData asParamData(RequestCaseContext context, JsonObject json) {
        JsonValue name = (JsonValue)json.get((Object)NAME);
        return context.resultFor(String.valueOf(name), () -> {
            ParamData paramData = new ParamData(json.getString(NAME), RequestCaseJson.asMessageData(context, json));
            paramData.setLocation(context.resultFor(IN, () -> ParamDef.Location.valueOf(json.getString(IN).toUpperCase())));
            paramData.setStyle(context.resultFor(STYLE, () -> json.getString(STYLE)));
            paramData.setExploded(context.resultFor(EXPLODE, () -> json.getBoolean(EXPLODE, false)));
            return paramData;
        });
    }

    private static MessageData asMessageData(RequestCaseContext context, JsonObject json) {
        String mediaType = context.resultFor(MEDIA_TYPE, () -> json.getString(MEDIA_TYPE, null));
        boolean valid = context.resultFor(VALID, () -> json.getBoolean(VALID));
        DataValue value = context.resultFor(DATA, () -> Optional.ofNullable(json.get((Object)DATA)).map(v -> RequestCaseJson.asDataValue(context, v)).orElse(null));
        return new MessageData(value, mediaType, valid);
    }

    private static DataValue<?> asDataValue(RequestCaseContext context, JsonValue json) {
        DataValue data;
        JsonValue.ValueType jsonType = json.getValueType();
        if (jsonType == JsonValue.ValueType.NULL) {
            data = null;
        } else if (jsonType == JsonValue.ValueType.OBJECT) {
            JsonObject object = (JsonObject)json;
            String type = context.resultFor(TYPE, () -> object.getString(TYPE));
            String format = context.resultFor(FORMAT, () -> object.getString(FORMAT, null));
            data = context.resultFor(VALUE, () -> type.equals("array") ? RequestCaseJson.asArrayValue(context, object.getJsonArray(VALUE)) : (type.equals("boolean") ? new BooleanValue(object.getBoolean(VALUE)) : (type.equals("integer") ? RequestCaseJson.asIntegerValue(context, object.getJsonNumber(VALUE), format) : (type.equals("null") ? new NullValue() : (type.equals("number") ? new DecimalValue(object.getJsonNumber(VALUE).bigDecimalValue(), format) : (type.equals("object") ? RequestCaseJson.asObjectValue(context, object.getJsonObject(VALUE)) : RequestCaseJson.asStringValue(context, object.getString(VALUE), format)))))));
        } else {
            throw new RequestCaseException(String.format("Invalid value type=%s -- must be either \"null\" or \"object\"", jsonType));
        }
        return data;
    }

    private static ArrayValue<?> asArrayValue(RequestCaseContext context, JsonArray json) {
        return new ArrayValue(IntStream.range(0, json.size()).mapToObj(i -> context.resultFor(String.valueOf(i), () -> RequestCaseJson.asDataValue(context, (JsonValue)json.get(i)))).collect(Collectors.toList()));
    }

    private static DataValue<?> asIntegerValue(RequestCaseContext context, JsonNumber json, String format) {
        return "int64".equals(format) ? new LongValue(json.longValueExact()) : new IntegerValue(json.intValueExact());
    }

    private static ObjectValue asObjectValue(RequestCaseContext context, JsonObject json) {
        return new ObjectValue(json.keySet().stream().collect(Collectors.toMap(key -> key, key -> context.resultFor((String)key, () -> RequestCaseJson.asDataValue(context, (JsonValue)json.get(key))), (v1, v2) -> {
            throw new IllegalStateException("Duplicated object property name");
        }, LinkedHashMap::new)));
    }

    private static DataValue<?> asStringValue(RequestCaseContext context, String value, String format) {
        return "date".equals(format) ? new DateValue(value) : ("date-time".equals(format) ? new DateTimeValue(value) : ("uuid".equals(format) ? new UuidValue(value) : ("binary".equals(format) ? new BinaryValue(Base64Domain.decoded(value)) : ("email".equals(format) ? new EmailValue(value) : new StringValue(value, format)))));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AuthDef asAuthDef(RequestCaseContext context, JsonObject json) {
        void var2_7;
        String type = json.getString(TYPE);
        if ("apiKey".equals(type)) {
            ApiKeyDef apiKeyDef = new ApiKeyDef(ParamDef.Location.valueOf(json.getString(LOCATION).toUpperCase()), json.getString(NAME));
            return var2_7;
        } else {
            if (!"http".equals(type)) throw new RequestCaseException(String.format("Authentication type=%s is not supported", type));
            String scheme = json.getString(SCHEME);
            if ("basic".equals(scheme)) {
                HttpBasicDef httpBasicDef = new HttpBasicDef();
                return var2_7;
            } else {
                if (!"bearer".equals(scheme)) throw new RequestCaseException(String.format("HTTP authentication scheme=%s is not supported", scheme));
                HttpBearerDef httpBearerDef = new HttpBearerDef();
            }
        }
        return var2_7;
    }

    private static class AuthDefJson
    implements AuthDefVisitor {
        private final AuthDef authDef_;
        private JsonValue json_;

        public static JsonValue toJson(AuthDef authDef) {
            return new AuthDefJson(authDef).toJson();
        }

        private AuthDefJson(AuthDef authDef) {
            this.authDef_ = authDef;
        }

        private JsonValue toJson() {
            this.authDef_.accept(this);
            return this.json_;
        }

        @Override
        public void visit(ApiKeyDef authDef) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add(RequestCaseJson.TYPE, "apiKey");
            builder.add(RequestCaseJson.LOCATION, String.valueOf((Object)authDef.getLocation()).toLowerCase());
            builder.add(RequestCaseJson.NAME, authDef.getName());
            this.json_ = builder.build();
        }

        @Override
        public void visit(HttpBasicDef authDef) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add(RequestCaseJson.TYPE, "http");
            builder.add(RequestCaseJson.SCHEME, "basic");
            this.json_ = builder.build();
        }

        @Override
        public void visit(HttpBearerDef authDef) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add(RequestCaseJson.TYPE, "http");
            builder.add(RequestCaseJson.SCHEME, "bearer");
            this.json_ = builder.build();
        }
    }

    private static class DataValueJson
    implements DataValueVisitor {
        private final DataValue<?> value_;
        private JsonValue json_;

        public static JsonValue toJson(DataValue<?> value) {
            return new DataValueJson(value).toJson();
        }

        private DataValueJson(DataValue<?> value) {
            this.value_ = value;
        }

        private JsonValue toJson() {
            this.value_.accept(this);
            return this.json_;
        }

        @Override
        public void visit(ArrayValue<?> data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            ((List)data.getValue()).stream().forEach(item -> builder.add((JsonValue)RequestCaseJson.toJson(item)));
            this.json_ = builder.build();
        }

        @Override
        public void visit(BinaryValue data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            builder.add(Base64Domain.encoded((byte[])data.getValue()));
            this.json_ = (JsonValue)builder.build().get(0);
        }

        @Override
        public void visit(BooleanValue data) {
            this.json_ = ((Boolean)data.getValue()).equals(Boolean.TRUE) ? JsonValue.TRUE : JsonValue.FALSE;
        }

        @Override
        public void visit(DecimalValue data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            builder.add((BigDecimal)data.getValue());
            this.json_ = (JsonValue)builder.build().get(0);
        }

        @Override
        public void visit(IntegerValue data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            builder.add(((Integer)data.getValue()).intValue());
            this.json_ = (JsonValue)builder.build().get(0);
        }

        @Override
        public void visit(LongValue data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            builder.add(((Long)data.getValue()).longValue());
            this.json_ = (JsonValue)builder.build().get(0);
        }

        @Override
        public void visit(NullValue data) {
            this.json_ = JsonValue.NULL;
        }

        @Override
        public void visit(ObjectValue data) {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            ((Map)data.getValue()).keySet().stream().forEach(key -> builder.add(key, (JsonValue)RequestCaseJson.toJson((DataValue)((Map)data.getValue()).get(key))));
            this.json_ = builder.build();
        }

        @Override
        public void visit(StringValue data) {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            builder.add((String)data.getValue());
            this.json_ = (JsonValue)builder.build().get(0);
        }
    }
}

