/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.VarBinding;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.AbstractStringDomain;
import org.cornutum.tcases.openapi.resolver.AbstractValueDomain;
import org.cornutum.tcases.openapi.resolver.ArrayConstant;
import org.cornutum.tcases.openapi.resolver.ArrayDomain;
import org.cornutum.tcases.openapi.resolver.AsciiStringDomain;
import org.cornutum.tcases.openapi.resolver.Base64Domain;
import org.cornutum.tcases.openapi.resolver.BinaryConstant;
import org.cornutum.tcases.openapi.resolver.BinaryDomain;
import org.cornutum.tcases.openapi.resolver.BooleanConstant;
import org.cornutum.tcases.openapi.resolver.BooleanEnum;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DateConstant;
import org.cornutum.tcases.openapi.resolver.DateDomain;
import org.cornutum.tcases.openapi.resolver.DateEnum;
import org.cornutum.tcases.openapi.resolver.DateTimeConstant;
import org.cornutum.tcases.openapi.resolver.DateTimeDomain;
import org.cornutum.tcases.openapi.resolver.DateTimeEnum;
import org.cornutum.tcases.openapi.resolver.DecimalConstant;
import org.cornutum.tcases.openapi.resolver.DecimalDomain;
import org.cornutum.tcases.openapi.resolver.DecimalEnum;
import org.cornutum.tcases.openapi.resolver.EmailConstant;
import org.cornutum.tcases.openapi.resolver.EmailDomain;
import org.cornutum.tcases.openapi.resolver.EmailEnum;
import org.cornutum.tcases.openapi.resolver.IntegerConstant;
import org.cornutum.tcases.openapi.resolver.IntegerDomain;
import org.cornutum.tcases.openapi.resolver.IntegerEnum;
import org.cornutum.tcases.openapi.resolver.JsonNodes;
import org.cornutum.tcases.openapi.resolver.LongConstant;
import org.cornutum.tcases.openapi.resolver.LongDomain;
import org.cornutum.tcases.openapi.resolver.LongEnum;
import org.cornutum.tcases.openapi.resolver.MultiTypeDomain;
import org.cornutum.tcases.openapi.resolver.NullDomain;
import org.cornutum.tcases.openapi.resolver.NumberDomain;
import org.cornutum.tcases.openapi.resolver.ObjectConstant;
import org.cornutum.tcases.openapi.resolver.ObjectDomain;
import org.cornutum.tcases.openapi.resolver.SequenceDomain;
import org.cornutum.tcases.openapi.resolver.StringConstant;
import org.cornutum.tcases.openapi.resolver.StringEnum;
import org.cornutum.tcases.openapi.resolver.UuidConstant;
import org.cornutum.tcases.openapi.resolver.UuidDomain;
import org.cornutum.tcases.openapi.resolver.UuidEnum;
import org.cornutum.tcases.openapi.resolver.ValueDomain;

public final class VarProperties {
    private static final Pattern valueTypePattern_ = Pattern.compile("(Not )?(.*)");

    private VarProperties() {
    }

    public static Map<String, Object> getPropertyValues(List<VarBinding> bindings) {
        LinkedHashMap<String, Object> propertyValues = new LinkedHashMap<String, Object>();
        bindings.stream().forEach(binding -> VarProperties.putPropertyValue(propertyValues, VarProperties.getPathRest(VarProperties.getVarPath(binding)), binding));
        return propertyValues;
    }

    public static void putPropertyValue(Map<String, Object> propertyValues, List<String> path, VarBinding binding) {
        String pathFirst = VarProperties.getPathFirst(path);
        if (path.size() == 1) {
            propertyValues.put(pathFirst, binding);
        } else {
            Map restValues = Optional.ofNullable((Map)propertyValues.get(pathFirst)).orElse(new LinkedHashMap());
            propertyValues.put(pathFirst, restValues);
            VarProperties.putPropertyValue(restValues, VarProperties.getPathRest(path), binding);
        }
    }

    public static VarBinding getVarBinding(Map<String, Object> propertyValues, String path) {
        try {
            return (VarBinding)VarProperties.getPropertyValue(propertyValues, path);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't get VarBinding for variable=%s", path), e);
        }
    }

    public static VarBinding getIfVarBinding(Map<String, Object> propertyValues, String path) {
        try {
            return VarProperties.getVarBinding(propertyValues, path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Object> getPropertyValues(Map<String, Object> propertyValues, String path) {
        try {
            return (Map)VarProperties.getPropertyValue(propertyValues, path);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Can't get value set at path=%s", path), e);
        }
    }

    public static Map<String, Object> getIfPropertyValues(Map<String, Object> propertyValues, String path) {
        try {
            return VarProperties.getPropertyValues(propertyValues, path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static VarBinding expectVarBinding(Map<String, Object> propertyValues, String path) {
        return Optional.ofNullable(VarProperties.getVarBinding(propertyValues, path)).orElseThrow(() -> new IllegalStateException(String.format("Variable=%s is undefined", path)));
    }

    public static Map<String, Object> expectPropertyValues(Map<String, Object> propertyValues, String path) {
        return Optional.ofNullable(VarProperties.getPropertyValues(propertyValues, path)).orElseThrow(() -> new IllegalStateException(String.format("No value set defined at path=%s", path)));
    }

    public static Object getPropertyValue(Map<String, Object> propertyValues, String path) {
        return VarProperties.getPropertyValue(propertyValues, VarProperties.getValuePath(path));
    }

    public static Object getPropertyValue(Map<String, Object> propertyValues, List<String> valuePath) {
        Object valueFirst;
        int valuePathSize = valuePath == null ? 0 : valuePath.size();
        Object object = valueFirst = valuePathSize > 0 ? propertyValues.get(VarProperties.getPathFirst(valuePath)) : null;
        return valuePathSize == 1 ? valueFirst : (valueFirst != null ? VarProperties.getPropertyValue((Map<String, Object>)((Map)valueFirst), VarProperties.getPathRest(valuePath)) : null);
    }

    public static Stream<VarBinding> getVarBindings(Map<String, Object> propertyValues) {
        return propertyValues.values().stream().flatMap(value -> value instanceof VarBinding ? Stream.of((VarBinding)value) : VarProperties.getVarBindings((Map)value));
    }

    public static List<String> getVarPath(VarBinding binding) {
        return VarProperties.getValuePath(binding.getVar());
    }

    public static List<String> getValuePath(String path) {
        return path == null ? null : Arrays.stream(DefUtils.toPath((String)path)).collect(Collectors.toList());
    }

    public static String getPathFirst(List<String> path) {
        return path.get(0);
    }

    public static List<String> getPathRest(List<String> path) {
        return path.subList(1, path.size());
    }

    public static Map<String, Object> getAlternativePropertyValues(Map<String, Object> propertyValues) {
        return Optional.ofNullable(propertyValues).flatMap(properties -> Optional.ofNullable(VarProperties.getPropertyValues(properties, "Alternative"))).map(alternatives -> VarProperties.getPropertyValues(alternatives, String.valueOf(VarProperties.getVarBinding(alternatives, "Used").getValue()))).orElse(propertyValues);
    }

    public static DataValue.Type[] getValueTypes(Map<String, Object> propertyValues) {
        Optional<VarBinding> typeDef = Optional.ofNullable(propertyValues).flatMap(pv -> Optional.ofNullable(VarProperties.getVarBinding(pv, "Type"))).filter(td -> !td.isValueNA());
        Optional<String> typeValue = typeDef.flatMap(td -> Optional.ofNullable(td.getValue()).map(String::valueOf));
        Optional<String> excludedTypeValue = Optional.ofNullable(propertyValues).flatMap(pv -> Optional.ofNullable(VarProperties.getVarBinding(pv, "Defined"))).map(defined -> defined.getAnnotation("excludedType"));
        DataValue.Type[] types = propertyValues == null ? DataValue.Type.any() : (!typeDef.isPresent() ? (excludedTypeValue.isPresent() ? VarProperties.getValueTypes(excludedTypeValue) : null) : VarProperties.getValueTypes(typeValue));
        return types;
    }

    private static DataValue.Type[] getValueTypes(Optional<String> typeValue) {
        DataValue.Type[] types;
        if (!typeValue.isPresent()) {
            types = DataValue.Type.only(DataValue.Type.NULL);
        } else {
            DataValue.Type[] baseTypes;
            Matcher matcher = valueTypePattern_.matcher(typeValue.get());
            if (!matcher.matches()) {
                throw new IllegalStateException(String.format("Unknown value type=%s", typeValue.get()));
            }
            try {
                baseTypes = (DataValue.Type[])Arrays.stream(matcher.group(2).toUpperCase().split(",")).map(DataValue.Type::valueOf).toArray(DataValue.Type[]::new);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unknown value type", e);
            }
            types = matcher.group(1) == null ? baseTypes : DataValue.Type.not(baseTypes);
        }
        return types;
    }

    public static ValueDomain<?> toValueDomain(Map<String, Object> propertyValues, Characters chars) {
        Map<String, Object> valueProperties = VarProperties.getAlternativePropertyValues(propertyValues);
        DataValue.Type[] types = VarProperties.getValueTypes(valueProperties);
        return types == null ? null : (types.length > 1 ? new MultiTypeDomain(chars, types) : (types[0] == DataValue.Type.ARRAY ? VarProperties.toArrayDomain(valueProperties, chars) : (types[0] == DataValue.Type.BOOLEAN ? VarProperties.toBooleanDomain(valueProperties) : (types[0] == DataValue.Type.INTEGER ? VarProperties.toNumberDomain(DataValue.Type.INTEGER, valueProperties) : (types[0] == DataValue.Type.NULL ? new NullDomain() : (types[0] == DataValue.Type.NUMBER ? VarProperties.toNumberDomain(DataValue.Type.NUMBER, valueProperties) : (types[0] == DataValue.Type.OBJECT ? VarProperties.toObjectDomain(valueProperties, chars) : (types[0] == DataValue.Type.STRING ? VarProperties.toStringDomain(valueProperties, chars) : null))))))));
    }

    public static ValueDomain<?> toItemsDomain(Map<String, Object> propertyValues, Characters chars) {
        DataValue.Type[] types;
        Map<String, Object> valueProperties = VarProperties.getAlternativePropertyValues(propertyValues);
        DataValue.Type[] typeArray = types = valueProperties == null ? DataValue.Type.any() : (DataValue.Type[])Optional.ofNullable(VarProperties.expectVarBinding(valueProperties, "Type").getAnnotation("itemType")).map(type -> VarProperties.getValueTypes(Optional.of(type))).orElse(null);
        return types == null ? null : (types.length > 1 ? new MultiTypeDomain(chars, types) : (types[0] == DataValue.Type.ARRAY ? VarProperties.toArrayItemsDomain(valueProperties, chars) : (types[0] == DataValue.Type.BOOLEAN ? VarProperties.toBooleanItemsDomain(valueProperties) : (types[0] == DataValue.Type.INTEGER ? VarProperties.toNumberItemsDomain(DataValue.Type.INTEGER, valueProperties) : (types[0] == DataValue.Type.NUMBER ? VarProperties.toNumberItemsDomain(DataValue.Type.NUMBER, valueProperties) : (types[0] == DataValue.Type.OBJECT ? new ObjectDomain(chars) : (types[0] == DataValue.Type.STRING ? VarProperties.toStringItemsDomain(valueProperties, chars) : null)))))));
    }

    public static ValueDomain<?> toArrayDomain(Map<String, Object> propertyValues, Characters chars) {
        AbstractValueDomain domain;
        VarBinding value = VarProperties.getIfVarBinding(propertyValues, "Value");
        if (value != null) {
            domain = new ArrayConstant(JsonNodes.toArrayValue(value.getValue()));
        } else {
            ArrayDomain<Object> arrayDomain;
            Map<String, Object> items = VarProperties.getPropertyValues(propertyValues, "Items");
            if (items == null) {
                arrayDomain = new ArrayDomain();
            } else {
                Map<String, Object> itemValueProperties = VarProperties.expectPropertyValues(items, "Contains");
                ValueDomain<?> otherItemValues = VarProperties.toItemsDomain(itemValueProperties, chars);
                ValueDomain<?> itemValues = VarProperties.toValueDomain(itemValueProperties, chars);
                ValueDomain<?> itemDomain = itemValues == null ? otherItemValues : itemValues;
                arrayDomain = itemDomain.arrayOf();
                arrayDomain.setOtherItemValues(otherItemValues);
                VarBinding size = VarProperties.expectVarBinding(items, "Size");
                arrayDomain.setItemCount(NumberDomain.Range.of(size));
                arrayDomain.setItemsUnique(Optional.ofNullable(VarProperties.getVarBinding(items, "Unique")).filter(u -> !u.isValueNA()).map(u -> "Yes".equals(u.getValue())).orElse(size.getAnnotation("itemsUnique") != null));
            }
            domain = arrayDomain;
        }
        return domain;
    }

    public static ValueDomain<?> toBooleanDomain(Map<String, Object> propertyValues) {
        return new BooleanConstant(Optional.ofNullable(VarProperties.getVarBinding(propertyValues, "Value")).map(b -> (Boolean)b.getValue()).orElse(true));
    }

    public static ValueDomain<?> toStringDomain(Map<String, Object> propertyValues, Characters chars) {
        AbstractValueDomain domain;
        Set<String> excluded;
        String format;
        Map<String, Object> stringProperties = VarProperties.getIfPropertyValues(propertyValues, "Value");
        VarBinding value = stringProperties == null ? (VarBinding)Optional.ofNullable(VarProperties.getVarBinding(propertyValues, "Value")).orElse(null) : (VarBinding)Optional.ofNullable(VarProperties.getVarBinding(stringProperties, "Is")).filter(v -> !v.isValueNA()).orElse(null);
        VarBinding length = Optional.ofNullable(stringProperties).flatMap(properties -> Optional.of(VarProperties.expectVarBinding(properties, "Length"))).filter(binding -> !binding.isValueNA()).orElse(null);
        if (value != null) {
            format = value.getAnnotation("format");
            excluded = Optional.ofNullable(value.getAnnotationList("excluded")).map(e -> e.stream().collect(Collectors.toSet())).orElse(Collections.emptySet());
        } else if (length != null) {
            format = length.getAnnotation("format");
            excluded = Collections.emptySet();
        } else {
            format = null;
            excluded = Collections.emptySet();
        }
        if (value != null && excluded.isEmpty()) {
            domain = "date".equals(format) ? new DateConstant(String.valueOf(value.getValue())) : ("date-time".equals(format) ? new DateTimeConstant(String.valueOf(value.getValue())) : ("uuid".equals(format) ? new UuidConstant(String.valueOf(value.getValue())) : ("binary".equals(format) ? new BinaryConstant((byte[])value.getValue()) : ("email".equals(format) ? new EmailConstant(String.valueOf(value.getValue()), chars) : new StringConstant(String.valueOf(value.getValue()), format, chars)))));
        } else {
            BinaryDomain baseDomain = "binary".equals(format) ? new BinaryDomain() : ("byte".equals(format) ? new Base64Domain() : ("date".equals(format) ? VarProperties.withPatterns(stringProperties, new DateDomain()) : ("date-time".equals(format) ? VarProperties.withPatterns(stringProperties, new DateTimeDomain()) : ("uuid".equals(format) ? VarProperties.withPatterns(stringProperties, new UuidDomain()) : ("email".equals(format) ? VarProperties.withPatterns(stringProperties, new EmailDomain(chars)) : VarProperties.withPatterns(stringProperties, new AsciiStringDomain(chars)))))));
            Optional.ofNullable(length).map(NumberDomain.Range::of).ifPresent(range -> baseDomain.setLengthRange((NumberDomain.Range)range));
            ((SequenceDomain)baseDomain).setExcludedStrings(excluded);
            domain = baseDomain;
        }
        return domain;
    }

    private static AbstractStringDomain withPatterns(Map<String, Object> stringProperties, AbstractStringDomain stringDomain) {
        List matchingPatterns = Optional.ofNullable(stringProperties).map(values -> Optional.ofNullable(VarProperties.getIfVarBinding(values, "Matches-Pattern")).map(matchesPattern -> {
            List matchesPatterns = matchesPattern.isValueNA() ? Collections.emptyList() : Arrays.asList(matchesPattern);
            return matchesPatterns;
        }).orElseGet(() -> Optional.ofNullable(VarProperties.getIfPropertyValues(values, "Matches-Patterns")).map(matchesPatterns -> VarProperties.getVarBindings(matchesPatterns).filter(matchesPattern -> !matchesPattern.isValueNA()).collect(Collectors.toList())).orElse(Collections.emptyList()))).orElse(Collections.emptyList());
        stringDomain.setMatching(matchingPatterns.stream().filter(binding -> "Yes".equals(binding.getValue())).map(binding -> binding.getAnnotation("pattern")).collect(Collectors.toList()));
        stringDomain.setNotMatching(matchingPatterns.stream().filter(binding -> "No".equals(binding.getValue())).map(binding -> binding.getAnnotation("pattern")).collect(Collectors.toList()));
        return stringDomain;
    }

    public static ValueDomain<?> toObjectDomain(Map<String, Object> propertyValues, Characters chars) {
        AbstractValueDomain domain;
        VarBinding value = VarProperties.getIfVarBinding(propertyValues, "Value");
        if (value != null) {
            domain = new ObjectConstant(JsonNodes.toObjectValue(value.getValue()));
        } else {
            ObjectDomain objDomain = new ObjectDomain(chars);
            Map<String, Object> valueProperties = VarProperties.getPropertyValues(propertyValues, "Value");
            if (valueProperties != null) {
                MultiTypeDomain additionalPropertyValues;
                Map<String, Object> properties = VarProperties.expectPropertyValues(valueProperties, "Properties");
                objDomain.setPropertyDomains(properties.keySet().stream().filter(p -> !p.equals("Additional")).map(p -> new AbstractMap.SimpleEntry((String)p, VarProperties.toPropertyDomain(VarProperties.expectPropertyValues(properties, p), chars))).filter(e -> e.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
                Map<String, Object> additionalProperties = VarProperties.getIfPropertyValues(properties, "Additional");
                MultiTypeDomain multiTypeDomain = additionalProperties != null ? VarProperties.toPropertyDomain(additionalProperties, chars) : (additionalPropertyValues = "Yes".equals(VarProperties.expectVarBinding(properties, "Additional").getValue()) ? new MultiTypeDomain(chars, DataValue.Type.any()) : null);
                if (additionalPropertyValues != null) {
                    objDomain.setAdditionalPropertyValues(additionalPropertyValues);
                    IntegerDomain expectedPropertyCount = new IntegerDomain(Optional.ofNullable(VarProperties.getVarBinding(valueProperties, "Property-Count")).map(NumberDomain.Range::of).orElse(NumberDomain.Range.of(">=", "0")));
                    int definedPropertyCount = objDomain.getPropertyDomains().size();
                    int expectedPropertyCountMin = (Integer)expectedPropertyCount.getMin();
                    int additionalPropertyCountMin = Math.max(1, expectedPropertyCountMin - definedPropertyCount);
                    int expectedPropertyCountMax = (Integer)expectedPropertyCount.getMax();
                    int additionalPropertyCountMax = (long)expectedPropertyCountMax == expectedPropertyCount.getMaxRange() ? additionalPropertyCountMin + 2 : expectedPropertyCountMax - definedPropertyCount;
                    objDomain.setAdditionalPropertyCount(new IntegerDomain(additionalPropertyCountMin, additionalPropertyCountMax));
                }
            }
            domain = objDomain;
        }
        return domain;
    }

    private static ValueDomain<?> toPropertyDomain(Map<String, Object> propertyValues, Characters chars) {
        return "Yes".equals(VarProperties.expectVarBinding(propertyValues, "Defined").getValue()) ? VarProperties.toValueDomain(propertyValues, chars) : null;
    }

    public static ValueDomain<?> toNumberDomain(DataValue.Type type, Map<String, Object> propertyValues) {
        AbstractValueDomain valueDomain;
        boolean constant;
        NumberDomain.Range range;
        String format;
        Map<String, Object> valueProperties = VarProperties.getPropertyValues(propertyValues, "Value");
        if (valueProperties == null) {
            format = null;
            range = null;
            constant = false;
        } else {
            VarBinding is = VarProperties.expectVarBinding(valueProperties, "Is");
            format = is.getAnnotation("format");
            range = NumberDomain.Range.of(is);
            constant = range.isConstant();
        }
        if (constant) {
            valueDomain = type == DataValue.Type.NUMBER ? new DecimalConstant(new BigDecimal(range.getMax()), format) : ("int64".equals(format) ? new LongConstant(Long.valueOf(range.getMax())) : new IntegerConstant(Integer.valueOf(range.getMax())));
        } else {
            NumberDomain numberDomain = type == DataValue.Type.NUMBER ? new DecimalDomain(range, format) : ("int64".equals(format) ? new LongDomain(range) : new IntegerDomain(range));
            Map multipleOfValues = Optional.ofNullable(valueProperties).flatMap(value -> Optional.ofNullable(VarProperties.getPropertyValues(value, "Multiple-Of"))).orElse(Collections.emptyMap());
            multipleOfValues.keySet().stream().map(m -> VarProperties.expectVarBinding(multipleOfValues, m)).filter(binding -> "Yes".equals(binding.getValue())).map(binding -> binding.getAnnotation("multipleOf")).findAny().ifPresent(m -> numberDomain.setMultipleOf((String)m));
            numberDomain.setNotMultipleOfs((String[])multipleOfValues.keySet().stream().map(m -> VarProperties.expectVarBinding(multipleOfValues, m)).filter(binding -> "No".equals(binding.getValue())).map(binding -> binding.getAnnotation("multipleOf")).toArray(String[]::new));
            valueDomain = numberDomain;
        }
        return valueDomain;
    }

    public static ValueDomain<?> toArrayItemsDomain(Map<String, Object> propertyValues, Characters chars) {
        ArrayDomain<Object> domain;
        Map<String, Object> items = VarProperties.getPropertyValues(propertyValues, "Items");
        if (items == null) {
            domain = new ArrayDomain();
        } else {
            Map<String, Object> itemValueProperties = VarProperties.expectPropertyValues(items, "Contains");
            ValueDomain<?> otherItemValues = VarProperties.toItemsDomain(itemValueProperties, chars);
            ValueDomain<?> itemValues = VarProperties.toValueDomain(itemValueProperties, chars);
            ValueDomain<?> itemDomain = itemValues == null ? otherItemValues : itemValues;
            domain = itemDomain.arrayOf();
            VarBinding size = VarProperties.expectVarBinding(items, "Size");
            domain.setItemCount(Optional.ofNullable(size.getAnnotation("itemMinItems")).map(Integer::valueOf).orElse(null), Optional.ofNullable(size.getAnnotation("itemMaxItems")).map(Integer::valueOf).orElse(null));
        }
        return domain;
    }

    public static ValueDomain<?> toBooleanItemsDomain(Map<String, Object> propertyValues) {
        return Optional.ofNullable(VarProperties.getVarBinding(propertyValues, "Value").getAnnotationList("itemEnums")).map(enums -> new BooleanEnum((Iterable<String>)enums)).orElse(null);
    }

    public static ValueDomain<?> toStringItemsDomain(Map<String, Object> propertyValues, Characters chars) {
        AbstractValueDomain domain;
        VarBinding valueVar = VarProperties.getIfVarBinding(propertyValues, "Value");
        if (valueVar != null) {
            String format = valueVar.getAnnotation("format");
            List enums = valueVar.getAnnotationList("itemEnums");
            domain = "date".equals(format) ? new DateEnum(enums) : ("date-time".equals(format) ? new DateTimeEnum(enums) : ("uuid".equals(format) ? new UuidEnum(enums) : ("email".equals(format) ? new EmailEnum((Iterable<String>)enums, chars) : new StringEnum(enums, format, chars))));
        } else {
            VarBinding lengthVar = VarProperties.expectVarBinding(VarProperties.expectPropertyValues(propertyValues, "Value"), "Length");
            String format = lengthVar.getAnnotation("format");
            List patterns = lengthVar.getAnnotationList("itemPatterns");
            List notPatterns = lengthVar.getAnnotationList("itemPatterns");
            BinaryDomain baseDomain = "binary".equals(format) ? new BinaryDomain() : ("byte".equals(format) ? new Base64Domain() : ("date".equals(format) ? VarProperties.withItemPatterns(patterns, notPatterns, new DateDomain()) : ("date-time".equals(format) ? VarProperties.withItemPatterns(patterns, notPatterns, new DateTimeDomain()) : ("uuid".equals(format) ? VarProperties.withItemPatterns(patterns, notPatterns, new UuidDomain()) : ("email".equals(format) ? VarProperties.withItemPatterns(patterns, notPatterns, new EmailDomain(chars)) : VarProperties.withItemPatterns(patterns, notPatterns, new AsciiStringDomain(chars)))))));
            Integer minLength = Optional.ofNullable(lengthVar.getAnnotation("itemMinLength")).map(Integer::valueOf).orElse(null);
            Integer maxLength = Optional.ofNullable(lengthVar.getAnnotation("itemMaxLength")).map(Integer::valueOf).orElse(null);
            baseDomain.setLengthRange(minLength, maxLength);
            Set<String> excluded = Optional.ofNullable(lengthVar.getAnnotationList("itemNotEnums")).map(e -> e.stream().collect(Collectors.toSet())).orElse(Collections.emptySet());
            ((SequenceDomain)baseDomain).setExcludedStrings(excluded);
            domain = baseDomain;
        }
        return domain;
    }

    private static AbstractStringDomain withItemPatterns(List<String> patterns, List<String> notPatterns, AbstractStringDomain stringDomain) {
        if (patterns != null) {
            stringDomain.setMatching(patterns);
        }
        if (notPatterns != null) {
            stringDomain.setNotMatching(notPatterns);
        }
        return stringDomain;
    }

    public static ValueDomain<?> toNumberItemsDomain(DataValue.Type type, Map<String, Object> propertyValues) {
        AbstractValueDomain valueDomain;
        Optional<VarBinding> is = Optional.ofNullable(VarProperties.getPropertyValues(propertyValues, "Value")).map(valueProperties -> VarProperties.expectVarBinding(valueProperties, "Is"));
        String format = is.map(binding -> binding.getAnnotation("format")).orElse(null);
        List enums = is.map(binding -> binding.getAnnotationList("itemEnums")).orElse(null);
        if (enums != null) {
            valueDomain = type == DataValue.Type.NUMBER ? new DecimalEnum(enums, format) : ("int64".equals(format) ? new LongEnum(enums) : new IntegerEnum(enums));
        } else {
            String min = is.flatMap(binding -> Optional.ofNullable(binding.getAnnotation("itemMin"))).orElse(null);
            String max = is.flatMap(binding -> Optional.ofNullable(binding.getAnnotation("itemMax"))).orElse(null);
            Set<String> excluded = is.flatMap(binding -> Optional.ofNullable(binding.getAnnotationList("itemNotEnums"))).map(Collection::stream).orElse(Stream.empty()).collect(Collectors.toSet());
            NumberDomain.Range range = new NumberDomain.Range(min, false, max, false, excluded);
            NumberDomain numberDomain = type == DataValue.Type.NUMBER ? new DecimalDomain(range, format) : ("int64".equals(format) ? new LongDomain(range) : new IntegerDomain(range));
            is.flatMap(binding -> Optional.ofNullable(binding.getAnnotation("itemMultipleOf"))).ifPresent(multipleOf -> numberDomain.setMultipleOf((String)multipleOf));
            is.flatMap(binding -> Optional.ofNullable(binding.getAnnotationList("itemNotMultipleOfs"))).ifPresent(notMultipleOfs -> numberDomain.setNotMultipleOfs((String[])notMultipleOfs.stream().toArray(String[]::new)));
            valueDomain = numberDomain;
        }
        return valueDomain;
    }
}

