/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Optional;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.resolver.ArrayDomain;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.ValueDef;

public interface ValueDomain<T> {
    public Stream<DataValue<T>> values(ResolverContext var1);

    public boolean contains(T var1);

    default public boolean containsObject(Object object) {
        try {
            Object value = object == null ? null : object;
            return this.contains(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean contains(DataValue<?> value) {
        return this.containsObject(Optional.ofNullable(value).map(DataValue::getValue).orElse(null));
    }

    public DataValue.Type[] getTypes();

    default public DataValue<T> select(ResolverContext context) {
        return this.values(context).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Domain=%s is empty", this)));
    }

    default public T selectValue(ResolverContext context) {
        return this.select(context).getValue();
    }

    default public ValueDef<T> valueOf() {
        return new ValueDef(this);
    }

    default public ArrayDomain<T> arrayOf(int maxItems, boolean itemsUnique) {
        ArrayDomain arrayDomain = new ArrayDomain(maxItems);
        arrayDomain.setItemValues(this);
        arrayDomain.setItemsUnique(itemsUnique);
        return arrayDomain;
    }

    default public ArrayDomain<T> arrayOf(int maxItems) {
        return this.arrayOf(maxItems, false);
    }

    default public ArrayDomain<T> arrayOf() {
        return this.arrayOf(16);
    }
}

