/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.StringEnum;
import org.cornutum.tcases.openapi.resolver.UuidConstant;
import org.cornutum.tcases.openapi.resolver.UuidValue;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;
import org.cornutum.tcases.util.CollectionUtils;

public class UuidEnum
extends StringEnum {
    public UuidEnum(Iterable<String> enums) {
        super(UuidEnum.assertUuids(enums), "uuid");
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new UuidValue(value);
    }

    public static Iterable<String> assertUuids(Iterable<String> values) {
        CollectionUtils.toStream(values).filter(value -> !UuidConstant.isUuid(value)).findFirst().ifPresent(value -> {
            throw new ValueDomainException(String.format("Value=%s is not a valid UUID", value));
        });
        return values;
    }
}

