/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.OpenApiUtils;
import org.cornutum.tcases.openapi.resolver.AbstractStringDomain;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.UuidConstant;
import org.cornutum.tcases.openapi.resolver.UuidValue;

public class UuidDomain
extends AbstractStringDomain {
    private static final int MAX_LENGTH = OpenApiUtils.stringFormatMax("uuid");

    public UuidDomain() {
        super(MAX_LENGTH + 1, Characters.ASCII);
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new UuidValue(value);
    }

    @Override
    protected void initLengthRange() {
        this.setLengthRange(MAX_LENGTH);
    }

    @Override
    public boolean contains(String value) {
        return super.contains(value) && UuidConstant.isUuid(value);
    }

    @Override
    protected String newValue(ResolverContext context, int length) {
        byte[] randomBytes = new byte[16];
        context.getRandom().nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        String value = String.format("%s-%s-%s-%s-%s", UuidDomain.toHex(randomBytes, 0, 4), UuidDomain.toHex(randomBytes, 4, 2), UuidDomain.toHex(randomBytes, 6, 2), UuidDomain.toHex(randomBytes, 8, 2), UuidDomain.toHex(randomBytes, 10, 6));
        return length < value.length() ? value.substring(0, length) : (length > value.length() ? StringUtils.rightPad((String)value, (int)length, (char)'0') : value);
    }

    @Override
    protected boolean valuesEqual(String value1, String value2) {
        return value1.equalsIgnoreCase(value2);
    }

    private static String toHex(byte[] bytes, int start, int length) {
        byte[] component = Arrays.copyOfRange(bytes, start, start + length);
        StringBuilder hex = new StringBuilder();
        for (byte b : component) {
            String hexByte = StringUtils.leftPad((String)Long.toHexString(b), (int)2, (char)'0');
            hex.append(hexByte.substring(hexByte.length() - 2, hexByte.length()));
        }
        return hex.toString();
    }
}

