/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.regex.Pattern;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.StringConstant;
import org.cornutum.tcases.openapi.resolver.UuidValue;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class UuidConstant
extends StringConstant {
    private static final Pattern uuid_ = Pattern.compile("\\p{XDigit}{8}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{4}-\\p{XDigit}{12}");

    public UuidConstant(String value) {
        super(UuidConstant.assertUuid(value));
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new UuidValue(value);
    }

    public static boolean isUuid(String value) {
        return uuid_.matcher(value).matches();
    }

    public static String assertUuid(String value) {
        if (!UuidConstant.isUuid(value)) {
            throw new ValueDomainException(String.format("Value=%s is not a valid UUID", value));
        }
        return value;
    }
}

