/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.AbstractStringDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.util.ToString;

public abstract class TimeDomain
extends AbstractStringDomain {
    private Date minDate_;
    private Date maxDate_;

    protected TimeDomain(int maxLength, Date minDate, Date maxDate) {
        super(maxLength, Characters.ASCII);
        this.setDateRange(minDate, maxDate);
    }

    protected void setDateRange(Date minDate, Date maxDate) {
        this.minDate_ = Optional.ofNullable(minDate).orElse(this.getDefaultMinDate());
        this.maxDate_ = Optional.ofNullable(maxDate).orElse(this.getDefaultMaxDate());
    }

    public Date getMinDate() {
        return this.minDate_;
    }

    private Date getDefaultMinDate() {
        Calendar minDate = Calendar.getInstance();
        minDate.set(1, minDate.get(1) - 1);
        minDate.set(2, 0);
        minDate.set(5, 1);
        minDate.set(11, 0);
        minDate.set(12, 0);
        minDate.set(13, 0);
        minDate.set(14, 0);
        return minDate.getTime();
    }

    public Date getMaxDate() {
        return this.maxDate_;
    }

    private Date getDefaultMaxDate() {
        Calendar maxDate = Calendar.getInstance();
        maxDate.set(1, maxDate.get(1) + 2);
        maxDate.set(2, 0);
        maxDate.set(5, 1);
        maxDate.set(11, 0);
        maxDate.set(12, 0);
        maxDate.set(13, 0);
        maxDate.set(14, 0);
        return maxDate.getTime();
    }

    @Override
    public void setExcluded(Set<String> excluded) {
        super.setExcluded(excluded);
        this.getExcluded().stream().forEach(value -> this.assertValidTime((String)value));
    }

    @Override
    protected Stream<String> newValues(ResolverContext context) {
        return this.timeValues(context).map(this::format).map(value -> this.withLength(context, (String)value));
    }

    private String withLength(ResolverContext context, String value) {
        int length = (Integer)this.getLengthRange().selectValue(context);
        return length < value.length() ? value.substring(0, length) : (length > value.length() ? StringUtils.rightPad((String)value, (int)length, (char)'0') : value);
    }

    @Override
    public boolean contains(String value) {
        return super.contains(value) && this.isValidTime(value);
    }

    @Override
    protected String newValue(ResolverContext context, int length) {
        throw new UnsupportedOperationException();
    }

    protected abstract Stream<Date> timeValues(ResolverContext var1);

    protected abstract String assertValidTime(String var1);

    protected abstract boolean isValidTime(String var1);

    protected abstract String format(Date var1);

    @Override
    public String toString() {
        return ToString.getBuilder((Object)this).append((Object)this.format(this.getMinDate())).append((Object)this.format(this.getMaxDate())).toString();
    }
}

