/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.EnumDomain;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class StringEnum
extends EnumDomain<String> {
    private final String format_;

    public StringEnum(Iterable<String> enums, String format) {
        this(enums, format, Characters.ANY);
    }

    public StringEnum(Iterable<String> enums, String format, Characters chars) {
        super(DataValue.Type.STRING, enums);
        this.format_ = format;
        for (String value : enums) {
            if (chars.allowed(value)) continue;
            throw new ValueDomainException(String.format("'%s' is not allowed by %s", value, chars));
        }
    }

    @Override
    protected String valueOf(String value) {
        return value;
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new StringValue(value, this.format_);
    }
}

