/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.ConstantDomain;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class StringConstant
extends ConstantDomain<String> {
    private final String format_;

    public StringConstant(String value) {
        this(value, (String)null);
    }

    public StringConstant(String value, Characters chars) {
        this(value, null, chars);
    }

    public StringConstant(String value, String format) {
        this(value, format, Characters.ANY);
    }

    public StringConstant(String value, String format, Characters chars) {
        super(DataValue.Type.STRING, value);
        this.format_ = format;
        if (!chars.allowed(value)) {
            throw new ValueDomainException(String.format("'%s' is not allowed by %s", value, chars));
        }
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new StringValue(value, this.format_);
    }
}

