/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.resolver.AbstractValueDomain;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.LengthDomain;
import org.cornutum.tcases.openapi.resolver.NumberDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.util.ToString;

public abstract class SequenceDomain<T>
extends AbstractValueDomain<T> {
    private final int maxLength_;
    private LengthDomain lengthRange_;
    private Set<T> excluded_;

    protected SequenceDomain(int maxLength) {
        this.maxLength_ = maxLength;
        this.initLengthRange();
        this.setExcluded(null);
    }

    public int getMaxLength() {
        return this.maxLength_;
    }

    public void setLengthRange(Integer length) {
        this.setLengthRange(new LengthDomain(length));
    }

    public void setLengthRange(Integer min, Integer max) {
        int lowerBound = Optional.ofNullable(min).orElse(0);
        int upperBound = Optional.ofNullable(max).orElse(lowerBound > this.getMaxLength() ? lowerBound + 1 : this.getMaxLength());
        this.setLengthRange(new LengthDomain(lowerBound, upperBound));
    }

    public void setLengthRange(NumberDomain.Range range) {
        if (range == null) {
            this.setLengthRange(null, null);
        } else if (range.isConstant()) {
            this.setLengthRange(Integer.valueOf(range.getMin()));
        } else {
            Integer min = Optional.ofNullable(range.getMin()).map(Integer::valueOf).map(i -> range.isMinExclusive() ? i + 1 : i).orElse(null);
            Integer max = Optional.ofNullable(range.getMax()).map(Integer::valueOf).map(i -> range.isMaxExclusive() ? i - 1 : i).orElse(null);
            this.setLengthRange(min, max);
        }
    }

    protected void initLengthRange() {
        this.setLengthRange(null, null);
    }

    protected void setLengthRange(LengthDomain domain) {
        this.lengthRange_ = domain;
    }

    protected LengthDomain getLengthRange() {
        return this.lengthRange_;
    }

    public void setExcluded(Set<T> excluded) {
        this.excluded_ = Optional.ofNullable(excluded).orElse(Collections.emptySet());
    }

    public Set<T> getExcluded() {
        return this.excluded_;
    }

    public abstract void setExcludedStrings(Set<String> var1);

    protected abstract int getLength(T var1);

    @Override
    public DataValue.Type[] getTypes() {
        return DataValue.Type.only(DataValue.Type.STRING);
    }

    @Override
    public Stream<DataValue<T>> values(ResolverContext context) {
        return this.candidates(context).filter(value -> this.isNotExcluded(value, this.getExcluded())).map(value -> this.dataValueOf(value));
    }

    protected abstract Stream<T> candidates(ResolverContext var1);

    @Override
    public boolean contains(T value) {
        return value != null && this.getLengthRange().contains(this.getLength(value)) && this.isNotExcluded(value, this.getExcluded());
    }

    protected boolean isNotExcluded(T value, Set<T> excluded) {
        return excluded.stream().allMatch(e -> !this.valuesEqual(value, e));
    }

    protected boolean valuesEqual(T value1, T value2) {
        return value1.equals(value2);
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append("length", (Object)this.getLengthRange()).toString();
    }
}

