/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.ExecutionContext;
import org.cornutum.tcases.openapi.Notifier;
import org.cornutum.tcases.openapi.resolver.ResolverConditionNotifier;
import org.cornutum.tcases.openapi.resolver.ResolverException;
import org.cornutum.tcases.openapi.resolver.ResolverSkipException;

public class ResolverContext
extends ExecutionContext<ResolverException> {
    private Random random_;
    private Notifier notifier_;
    private int maxTries_;

    public ResolverContext(Random random) {
        this.setRandom(random);
        this.setNotifier(null);
        this.setMaxTries(10000);
    }

    @Override
    protected ResolverException whenFailure(Throwable e) {
        return ResolverException.class.isAssignableFrom(e.getClass()) ? (ResolverException)e : new ResolverException(this.getLocation(), e);
    }

    public void setRandom(Random random) {
        this.random_ = Optional.ofNullable(random).orElseThrow(() -> new IllegalStateException("Random number generator must be defined"));
    }

    public Random getRandom() {
        return this.random_;
    }

    public void setNotifier(Notifier notifier) {
        this.notifier_ = notifier == null ? ResolverConditionNotifier.log() : notifier;
    }

    public Notifier getNotifier() {
        return this.notifier_;
    }

    public void setMaxTries(int maxTries) {
        this.maxTries_ = maxTries;
    }

    public int getMaxTries() {
        return this.maxTries_;
    }

    public <T> T tryUntil(Supplier<Optional<T>> valueSupplier) throws ResolverSkipException {
        return this.tryUntil(Stream.generate(() -> (Optional)valueSupplier.get()));
    }

    public <T> T tryUntil(Stream<Optional<T>> results) throws ResolverSkipException {
        int tries;
        Iterator supplier = results.iterator();
        Object result = null;
        for (tries = 0; tries < this.getMaxTries() && supplier.hasNext() && (result = ((Optional)supplier.next()).orElse(null)) == null; ++tries) {
        }
        if (result == null) {
            throw new ResolverSkipException(this.getLocation(), String.format("Unable to resolve a value after %s tries", tries));
        }
        return result;
    }

    public void warn(String reason) {
        this.notifier_.warn(this.getLocation(), reason);
    }

    public void error(String reason, String resolution) {
        this.notifier_.error(this.getLocation(), reason, resolution);
    }

    public static Builder builder(Random random) {
        return new Builder(random);
    }

    public static class Builder {
        private ResolverContext resolverContext_;

        public Builder(Random random) {
            this.resolverContext_ = new ResolverContext(random);
        }

        public Builder notifier(Notifier notifier) {
            this.resolverContext_.setNotifier(notifier);
            return this;
        }

        public Builder maxTries(int maxTries) {
            this.resolverContext_.setMaxTries(maxTries);
            return this;
        }

        public ResolverContext build() {
            return this.resolverContext_;
        }
    }
}

