/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.cornutum.tcases.openapi.resolver.RequestCase;
import org.cornutum.tcases.util.ToString;

public class RequestTestDef {
    private List<RequestCase> requestCases_ = new ArrayList<RequestCase>();

    public RequestTestDef() {
    }

    public RequestTestDef(Iterable<RequestCase> requestCases) {
        if (requestCases != null) {
            for (RequestCase requestCase : requestCases) {
                this.add(requestCase);
            }
        }
    }

    public RequestTestDef add(RequestCase requestCase) {
        if (requestCase != null) {
            int i = this.requestCases_.indexOf(requestCase);
            if (i >= 0) {
                throw new IllegalArgumentException(String.format("%s is already defined", this.requestCases_.get(i)));
            }
            this.requestCases_.add(requestCase);
        }
        return this;
    }

    public RequestTestDef remove(RequestCase requestCase) {
        if (requestCase != null) {
            this.requestCases_.remove(requestCase);
        }
        return this;
    }

    public List<RequestCase> getRequestCases() {
        return Collections.unmodifiableList(this.requestCases_);
    }

    public List<RequestCase> getRequestCases(String path) {
        return this.getRequestCases((Collection<String>)Optional.ofNullable(path).map(Collections::singleton).orElse(null), (Collection<String>)null);
    }

    public List<RequestCase> getRequestCases(String path, String ... ops) {
        return this.getRequestCases(Optional.ofNullable(path).map(Collections::singleton).orElse(null), Arrays.stream(ops).collect(Collectors.toSet()));
    }

    public List<RequestCase> getRequestCases(Collection<String> paths, Collection<String> ops) {
        return this.requestCases_.stream().filter(rc -> !(paths != null && !paths.stream().anyMatch(p -> p.equalsIgnoreCase(rc.getPath())) || ops != null && !ops.stream().anyMatch(o -> o.equalsIgnoreCase(rc.getOperation())))).sorted().collect(Collectors.toList());
    }

    public Set<String> getPaths() {
        return this.requestCases_.stream().map(RequestCase::getPath).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<String> getOperations(String path) {
        return this.getRequestCases(path).stream().map(RequestCase::getOperation).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public String getApi() {
        return this.requestCases_.stream().map(RequestCase::getApi).findFirst().orElse(null);
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append((Object)this.getApi()).toString();
    }
}

