/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.cornutum.tcases.DefUtils;
import org.cornutum.tcases.FunctionTestDef;
import org.cornutum.tcases.SystemTestDef;
import org.cornutum.tcases.TestCase;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.MessageData;
import org.cornutum.tcases.openapi.resolver.ParamData;
import org.cornutum.tcases.openapi.resolver.ParamDef;
import org.cornutum.tcases.openapi.resolver.RequestCase;
import org.cornutum.tcases.openapi.resolver.RequestCaseDef;
import org.cornutum.tcases.openapi.resolver.RequestCaseDefiner;
import org.cornutum.tcases.openapi.resolver.RequestCaseException;
import org.cornutum.tcases.openapi.resolver.RequestCaseResolver;
import org.cornutum.tcases.openapi.resolver.RequestTestDef;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.util.CollectionUtils;

public final class RequestCases {
    private RequestCases() {
    }

    public static RequestTestDef realizeRequestCases(RequestTestDef requestTestDef) {
        RequestTestDef realizable = new RequestTestDef(requestTestDef.getRequestCases().stream().filter(RequestCases::isSerializable).collect(Collectors.toList()));
        RequestCases.getSerializedDups(realizable).forEach(rc -> realizable.remove((RequestCase)rc));
        return realizable;
    }

    public static RequestTestDef getRequestCases(SystemTestDef testDef, ResolverContext context) {
        RequestCaseResolver resolver = new RequestCaseResolver(context);
        return new RequestTestDef(RequestCases.getRequestCaseDefs(testDef).stream().map(requestCaseDef -> resolver.resolve((RequestCaseDef)requestCaseDef)).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static List<RequestCaseDef> getRequestCaseDefs(SystemTestDef testDef) {
        return RequestCases.getRequestCaseDefs(new RequestCaseDefiner(), testDef);
    }

    private static List<RequestCaseDef> getRequestCaseDefs(RequestCaseDefiner definer, SystemTestDef testDef) {
        return CollectionUtils.toStream((Iterator)testDef.getFunctionTestDefs()).flatMap(function -> RequestCases.getRequestCaseDefs(definer, function).stream()).collect(Collectors.toList());
    }

    private static List<RequestCaseDef> getRequestCaseDefs(RequestCaseDefiner definer, FunctionTestDef testDef) {
        return CollectionUtils.toStream((Iterator)testDef.getTestCases()).map(testCase -> {
            try {
                return definer.toRequestCaseDef((TestCase)testCase);
            }
            catch (Exception e) {
                throw new RequestCaseException(String.format("Can't get request case for function=%s, test case=%s", testDef.getName(), testCase.getId()), (Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    private static boolean isSerializable(RequestCase requestCase) {
        boolean stringTypeFailure = Optional.ofNullable(requestCase.getInvalidInput()).map(invalidInput -> invalidInput.endsWith("Type=Not string")).orElse(false);
        boolean invalidBodyJson = Optional.ofNullable(stringTypeFailure ? requestCase.getBody() : null).map(body -> !body.isValid() && "application/json".equals(body.getMediaType())).orElse(false);
        return !stringTypeFailure || invalidBodyJson;
    }

    private static List<RequestCase> getSerializedDups(RequestTestDef requestTestDef) {
        ArrayList<RequestCase> dups = new ArrayList<RequestCase>();
        for (String path : requestTestDef.getPaths()) {
            for (String op : requestTestDef.getOperations(path)) {
                dups.addAll(RequestCases.getSerializedDups(requestTestDef.getRequestCases(path, op)));
            }
        }
        return dups;
    }

    private static List<RequestCase> getSerializedDups(List<RequestCase> requestCases) {
        List nullFailureCases = requestCases.stream().filter(RequestCases::isNullFailure).collect(Collectors.toList());
        Map<String, DataValue.Type> nullFailureTypes = nullFailureCases.stream().collect(Collectors.toMap(rc -> RequestCases.nullFailureId(rc), rc -> RequestCases.nullFailureType(requestCases, rc)));
        return nullFailureTypes.keySet().stream().flatMap(id -> {
            DataValue.Type idType = (DataValue.Type)((Object)((Object)nullFailureTypes.get(id)));
            return requestCases.stream().filter(rc -> RequestCases.isArrayEmptyFailureDup(rc, id) || RequestCases.isStringEmptyFailureDup(rc, id) || RequestCases.isUndefinedFailureDup(rc, id, idType));
        }).collect(Collectors.toList());
    }

    private static boolean isNullFailure(RequestCase requestCase) {
        return Optional.ofNullable(requestCase.getInvalidInput()).map(invalid -> invalid.endsWith(".Type=null")).orElse(false);
    }

    private static String nullFailureId(RequestCase nullFailure) {
        String invalidInput = nullFailure.getInvalidInput();
        return invalidInput.substring(0, invalidInput.lastIndexOf(".Type=null"));
    }

    private static DataValue.Type nullFailureType(List<RequestCase> requestCases, RequestCase nullFailure) {
        String paramName = RequestCases.getFailureData(nullFailure).filter(failure -> failure instanceof ParamData).map(failure -> ((ParamData)failure).getName()).orElse(null);
        return requestCases.stream().map(rc -> Optional.ofNullable(paramName).map(p -> {
            MessageData paramData = CollectionUtils.toStream(rc.getParams()).filter(param -> param.getName().equals(paramName)).findFirst().get();
            return paramData;
        }).orElse(rc.getBody())).filter(MessageData::isValid).findFirst().map(MessageData::getType).orElseThrow(() -> new IllegalStateException(String.format("Can't find null failure type for %s", nullFailure)));
    }

    private static boolean isStringEmptyFailureDup(RequestCase requestCase, String inputId) {
        return RequestCases.getFailureData(requestCase).filter(failure -> requestCase.getInvalidInput().equals(String.format("%s.Value.Length=0", inputId))).map(failure -> failure instanceof ParamData || !"application/json".equals(failure.getMediaType())).orElse(false);
    }

    private static boolean isArrayEmptyFailureDup(RequestCase requestCase, String inputId) {
        return RequestCases.getFailureData(requestCase).filter(failure -> requestCase.getInvalidInput().equals(String.format("%s.Items.Size=0", inputId))).map(failure -> failure instanceof ParamData || !"application/json".equals(failure.getMediaType())).orElse(false);
    }

    private static boolean isUndefinedFailureDup(RequestCase requestCase, String inputId, DataValue.Type inputType) {
        return RequestCases.getFailureData(requestCase).filter(failure -> requestCase.getInvalidInput().equals(String.format("%s.Defined=No", inputId))).map(failure -> {
            ParamData param = failure instanceof ParamData ? (ParamData)failure : null;
            return param != null && param.getStyle().equals("simple") && param.getLocation() == ParamDef.Location.PATH && (!inputType.isComposite() || inputId.equals(DefUtils.toIdentifier((String)param.getName())));
        }).orElse(false);
    }

    private static Optional<MessageData> getFailureData(RequestCase requestCase) {
        return Optional.of(requestCase).filter(RequestCase::isFailure).map(rc -> CollectionUtils.toStream(rc.getParams()).filter(param -> !param.isValid()).findFirst().map(param -> param).orElse(rc.getBody()));
    }
}

