/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Optional;
import java.util.stream.Collectors;
import org.cornutum.tcases.openapi.ConditionReporter;
import org.cornutum.tcases.openapi.InvalidStyleException;
import org.cornutum.tcases.openapi.OpenApiUtils;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.MessageData;
import org.cornutum.tcases.openapi.resolver.ParamData;
import org.cornutum.tcases.openapi.resolver.ParamDef;
import org.cornutum.tcases.openapi.resolver.RequestCase;
import org.cornutum.tcases.openapi.resolver.RequestCaseDef;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.ResolverException;
import org.cornutum.tcases.openapi.resolver.ResolverSkipException;
import org.cornutum.tcases.openapi.resolver.ValueDef;
import org.cornutum.tcases.openapi.resolver.ValueDomain;
import org.cornutum.tcases.util.CollectionUtils;

public class RequestCaseResolver
extends ConditionReporter<ResolverContext> {
    public RequestCaseResolver(ResolverContext context) {
        super(context);
        this.setNotifier(context.getNotifier());
    }

    public RequestCase resolve(RequestCaseDef requestCaseDef) {
        return this.resultFor(String.valueOf(requestCaseDef), () -> {
            try {
                RequestCase requestCase = new RequestCase(requestCaseDef.getId());
                requestCase.setName(requestCaseDef.getName());
                requestCase.setServer(requestCaseDef.getServer());
                requestCase.setVersion(requestCaseDef.getVersion());
                requestCase.setApi(requestCaseDef.getApi());
                requestCase.setPath(requestCaseDef.getPath());
                requestCase.setOperation(requestCaseDef.getOperation());
                requestCase.setInvalidInput(requestCaseDef.getInvalidInput());
                requestCase.setAuthDefs(requestCaseDef.getAuthDefs());
                requestCase.setAuthFailure(requestCaseDef.isAuthFailure());
                requestCase.setParams(CollectionUtils.toStream(requestCaseDef.getParams()).map(paramDef -> this.resolveParamData((ParamDef)paramDef)).collect(Collectors.toList()));
                requestCase.setBody(this.resolveBody(requestCaseDef.getBody()));
                return requestCase;
            }
            catch (ResolverSkipException skip) {
                this.getNotifier().error(skip.getLocation(), skip.getMessage(), "No request case created for this test");
                return null;
            }
            catch (Exception e) {
                throw new ResolverException(String.format("Can't resolve %s", requestCaseDef), (Throwable)e);
            }
        });
    }

    private ParamData resolveParamData(ParamDef paramDef) {
        return this.resultFor(paramDef.getName(), () -> {
            try {
                ParamData paramData = new ParamData(paramDef.getName(), this.resolveMessageData(paramDef.getValue()));
                paramData.setLocation(paramDef.getLocation());
                paramData.setStyle(this.getApplicableStyle(paramDef.getStyle(), paramDef.getLocation(), paramData.getType()));
                paramData.setExploded(paramDef.isExploded());
                return paramData;
            }
            catch (ResolverSkipException skip) {
                throw skip;
            }
            catch (Exception e) {
                throw new ResolverException(String.format("Can't resolve parameter=%s", paramDef.getName()), (Throwable)e);
            }
        });
    }

    private String getApplicableStyle(String style, ParamDef.Location location, DataValue.Type type) {
        try {
            return OpenApiUtils.ifApplicableStyle(style, String.valueOf((Object)location).toLowerCase(), String.valueOf((Object)type).toLowerCase());
        }
        catch (InvalidStyleException e) {
            String applicableStyle = e.getValidStyle();
            this.notifyWarning(String.format("%s -- using style=%s instead", e.getMessage(), applicableStyle));
            return applicableStyle;
        }
    }

    private MessageData resolveBody(ValueDef<?> body) {
        return this.resultFor("requestBody", () -> {
            try {
                return Optional.ofNullable(body).map(this::resolveMessageData).orElse(null);
            }
            catch (ResolverSkipException skip) {
                throw skip;
            }
            catch (Exception e) {
                throw new ResolverException("Can't resolve request body", (Throwable)e);
            }
        });
    }

    private MessageData resolveMessageData(ValueDef<?> valueDef) {
        DataValue resolvedValue = valueDef.isDefined() ? this.resultFor("value", () -> this.domainValue(valueDef.getDomain())) : null;
        String resolvedMediaType = Optional.ofNullable(valueDef.getMediaType()).map(mediaType -> this.resultFor("mediaType", () -> (String)this.domainValue((ValueDomain)mediaType).getValue())).orElse(null);
        return new MessageData(resolvedValue, resolvedMediaType, valueDef.isValid());
    }

    private <T> DataValue<T> domainValue(ValueDomain<T> domain) {
        try {
            return domain.select((ResolverContext)this.getContext());
        }
        catch (ResolverSkipException skip) {
            throw skip;
        }
        catch (Exception e) {
            throw new ResolverException(String.format("Can't get value from %s", domain), (Throwable)e);
        }
    }
}

