/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.TestCase;
import org.cornutum.tcases.VarBinding;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.OpenApiUtils;
import org.cornutum.tcases.openapi.resolver.ApiKeyDef;
import org.cornutum.tcases.openapi.resolver.AuthDef;
import org.cornutum.tcases.openapi.resolver.HttpBasicDef;
import org.cornutum.tcases.openapi.resolver.HttpBearerDef;
import org.cornutum.tcases.openapi.resolver.MediaTypeDomain;
import org.cornutum.tcases.openapi.resolver.ParamDef;
import org.cornutum.tcases.openapi.resolver.RequestCaseDef;
import org.cornutum.tcases.openapi.resolver.RequestCaseException;
import org.cornutum.tcases.openapi.resolver.StringConstant;
import org.cornutum.tcases.openapi.resolver.ValueDef;
import org.cornutum.tcases.openapi.resolver.VarProperties;
import org.cornutum.tcases.util.CollectionUtils;

public class RequestCaseDefiner {
    public RequestCaseDef toRequestCaseDef(TestCase testCase) throws RequestCaseException {
        try {
            RequestCaseDef requestCaseDef;
            if (testCase == null) {
                requestCaseDef = null;
            } else {
                requestCaseDef = new RequestCaseDef(testCase.getId());
                requestCaseDef.setName(testCase.getName());
                requestCaseDef.setServer(Optional.ofNullable(testCase.getAnnotation("server")).map(uri -> {
                    try {
                        return new URI((String)uri);
                    }
                    catch (Exception e) {
                        throw new RequestCaseException("Can't convert server URI", (Throwable)e);
                    }
                }).orElse(null));
                requestCaseDef.setVersion(Optional.ofNullable(testCase.getAnnotation("version")).orElseThrow(() -> new RequestCaseException("No version annotation defined")));
                requestCaseDef.setApi(Optional.ofNullable(testCase.getAnnotation("title")).orElseThrow(() -> new RequestCaseException("No title annotation defined")));
                requestCaseDef.setPath(Optional.ofNullable(testCase.getAnnotation("path")).orElseThrow(() -> new RequestCaseException("No path annotation defined")));
                requestCaseDef.setOperation(Optional.ofNullable(testCase.getAnnotation("operation")).orElseThrow(() -> new RequestCaseException("No operation annotation defined")));
                requestCaseDef.setInvalidInput(Optional.ofNullable(testCase.getInvalidValue()).map(binding -> String.format("%s=%s", binding.getVar(), binding.getValue())).orElse(null));
                requestCaseDef.setAuthFailure(Optional.ofNullable(testCase.getInvalidValue()).map(binding -> binding.getAnnotation("authFailure") != null).orElse(false));
                this.paramProperties(testCase).forEach((paramName, paramProperties) -> requestCaseDef.addParam(this.toParamDef((String)paramName, (Map<String, Object>)paramProperties)));
                requestCaseDef.setBody(this.bodyValues(testCase).map(this::toBodyDef).orElse(null));
                this.authProperties(testCase).forEach(authProperties -> requestCaseDef.addAuthDef(this.toAuthDef((Map<String, Object>)authProperties)));
            }
            return requestCaseDef;
        }
        catch (Exception e) {
            throw new RequestCaseException(String.format("Can't convert test case=%s", testCase.getId()), (Throwable)e);
        }
    }

    private Map<String, Map<String, Object>> paramProperties(TestCase testCase) {
        return CollectionUtils.toStream((Iterator)testCase.getVarBindings()).filter(binding -> this.isParamInputType(binding.getType())).collect(Collectors.groupingBy(this::getInputName)).entrySet().stream().collect(Collectors.toMap(paramBindings -> this.getParamName((List)paramBindings.getValue()), paramBindings -> VarProperties.getPropertyValues((List)paramBindings.getValue())));
    }

    private boolean isParamInputType(String inputType) {
        return !"request".equals(inputType) && !"implicit".equals(inputType) && !"security".equals(inputType);
    }

    private Optional<Map<String, Object>> bodyValues(TestCase testCase) {
        return CollectionUtils.toStream((Iterator)testCase.getVarBindings()).filter(binding -> "request".equals(binding.getType())).collect(Collectors.groupingBy(this::getInputName)).entrySet().stream().findFirst().map(bodyBindings -> VarProperties.getPropertyValues((List)bodyBindings.getValue()));
    }

    private Stream<Map<String, Object>> authProperties(TestCase testCase) {
        Stream.Builder authProperties = Stream.builder();
        CollectionUtils.toStream((Iterator)testCase.getVarBindings()).filter(binding -> "security".equals(binding.getType())).collect(Collectors.groupingBy(this::getInputName)).entrySet().stream().findFirst().map(secBindings -> VarProperties.getPropertyValues((List)secBindings.getValue())).ifPresent(secProperties -> this.getAuthProperties((Map<String, Object>)secProperties, authProperties));
        return authProperties.build();
    }

    private void getAuthProperties(Map<String, Object> secProperties, Stream.Builder<Map<String, Object>> authProperties) {
        for (String property : secProperties.keySet()) {
            Optional<VarBinding> authType = Optional.ofNullable(VarProperties.getIfVarBinding(secProperties, property)).filter(binding -> "Type".equals(property) && !binding.isValueNA());
            if (authType.isPresent()) {
                authProperties.add(secProperties);
                continue;
            }
            Optional.ofNullable(VarProperties.getIfPropertyValues(secProperties, property)).ifPresent(memberProperties -> this.getAuthProperties((Map<String, Object>)memberProperties, authProperties));
        }
    }

    private String getInputName(VarBinding binding) {
        return VarProperties.getPathFirst(VarProperties.getVarPath(binding));
    }

    private String getParamName(List<VarBinding> bindings) {
        VarBinding binding = bindings.get(0);
        return Optional.ofNullable(binding.getAnnotation("paramName")).orElseThrow(() -> new RequestCaseException(String.format("No parameter name defined for var=%s", this.getInputName(binding))));
    }

    private ParamDef toParamDef(String paramName, Map<String, Object> propertyValues) {
        ParamDef paramDef = new ParamDef(paramName);
        VarBinding defined = VarProperties.expectVarBinding(propertyValues, "Defined");
        paramDef.setLocation(defined.getType());
        paramDef.setStyle(defined.getAnnotation("style"));
        paramDef.setExploded(Boolean.parseBoolean(defined.getAnnotation("explode")));
        paramDef.setValue(this.toValueDef(defined, null, propertyValues, this.getParamCharacters(paramDef)));
        return paramDef;
    }

    private Characters getParamCharacters(ParamDef param) {
        return OpenApiUtils.getParamCharacters(String.valueOf((Object)param.getLocation()).toLowerCase(), param.getStyle());
    }

    private ValueDef<?> toBodyDef(Map<String, Object> bodyValues) {
        VarBinding mediaType = VarProperties.expectVarBinding(bodyValues, "Media-Type");
        VarBinding contentDefined = VarProperties.expectVarBinding(bodyValues, "Defined");
        Map<String, Object> contentValues = VarProperties.getPropertyValues(bodyValues, String.valueOf(mediaType.getValue()));
        return this.toValueDef(contentDefined, mediaType, contentValues, Characters.ANY);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AuthDef toAuthDef(Map<String, Object> authValues) {
        void var2_7;
        String type = String.valueOf(VarProperties.expectVarBinding(authValues, "Type").getValue());
        if ("apiKey".equals(type)) {
            ApiKeyDef apiKeyDef = new ApiKeyDef(ParamDef.Location.valueOf(String.valueOf(VarProperties.expectVarBinding(authValues, "Location").getValue()).toUpperCase()), String.valueOf(VarProperties.expectVarBinding(authValues, "Name").getValue()));
            return var2_7;
        } else {
            if (!"http".equals(type)) throw new IllegalStateException(String.format("Authentication type=%s is not supported", type));
            String scheme = String.valueOf(VarProperties.expectVarBinding(authValues, "Scheme").getValue());
            if ("basic".equals(scheme)) {
                HttpBasicDef httpBasicDef = new HttpBasicDef();
                return var2_7;
            } else {
                if (!"bearer".equals(scheme)) throw new IllegalStateException(String.format("HTTP authentication scheme=%s is not supported", scheme));
                HttpBearerDef httpBearerDef = new HttpBearerDef();
            }
        }
        return var2_7;
    }

    private ValueDef<?> toValueDef(VarBinding defined, VarBinding mediaType, Map<String, Object> propertyValues, Characters chars) {
        boolean valueDefined = Optional.ofNullable(defined).map(binding -> "Yes".equals(binding.getValue())).orElse(true);
        ValueDef valueDef = valueDefined ? VarProperties.toValueDomain(propertyValues, chars).valueOf() : new ValueDef(null);
        valueDef.setValid(Stream.concat(Optional.ofNullable(defined).map(Stream::of).orElse(Stream.empty()), Stream.concat(Optional.ofNullable(mediaType).map(Stream::of).orElse(Stream.empty()), Optional.ofNullable(propertyValues).map(VarProperties::getVarBindings).orElse(Stream.empty()))).allMatch(VarBinding::isValueValid));
        Optional<String> mediaTypeSpecified = Optional.ofNullable(mediaType).map(binding -> binding.getAnnotation("mediaType"));
        Optional<Set> mediaTypesExcluded = Optional.ofNullable(mediaType).flatMap(binding -> Optional.ofNullable(binding.getAnnotationList("excluded"))).map(excluded -> (Set)excluded.stream().collect(CollectionUtils.toOrderedSet()));
        valueDef.setMediaType(mediaTypesExcluded.map(excluded -> MediaTypeDomain.except(excluded)).orElse(mediaTypeSpecified.map(StringConstant::new).orElse(null)));
        return valueDef;
    }
}

