/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.OpenApiUtils;
import org.cornutum.tcases.openapi.resolver.ArrayValue;
import org.cornutum.tcases.openapi.resolver.AuthDef;
import org.cornutum.tcases.openapi.resolver.BinaryValue;
import org.cornutum.tcases.openapi.resolver.BooleanValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DataValueVisitor;
import org.cornutum.tcases.openapi.resolver.DecimalValue;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.LongValue;
import org.cornutum.tcases.openapi.resolver.MessageData;
import org.cornutum.tcases.openapi.resolver.NullValue;
import org.cornutum.tcases.openapi.resolver.ObjectValue;
import org.cornutum.tcases.openapi.resolver.ParamData;
import org.cornutum.tcases.openapi.resolver.RequestCaseContext;
import org.cornutum.tcases.openapi.resolver.RequestCaseException;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.util.ToString;

public class RequestCase
implements Comparable<RequestCase> {
    private final int id_;
    private String name_;
    private URI server_;
    private String version_;
    private String api_;
    private String path_;
    private String op_;
    private List<ParamData> params_;
    private MessageData body_;
    private List<AuthDef> authDefs_;
    private String invalidInput_;
    private boolean authFailure_;

    public RequestCase(int id) {
        this.id_ = id;
        this.setParams(null);
        this.setAuthDefs(null);
    }

    public int getId() {
        return this.id_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public void setServer(URI uri) {
        this.server_ = uri;
    }

    public void setServer(String uri) {
        try {
            this.setServer(new URI(uri));
        }
        catch (Exception e) {
            throw new RequestCaseException(String.format("Invalid URI=%s", uri), (Throwable)e);
        }
    }

    public URI getServer() {
        return this.server_;
    }

    public void setVersion(String version) {
        this.version_ = version;
    }

    public String getVersion() {
        return this.version_;
    }

    public void setApi(String api) {
        this.api_ = api;
    }

    public String getApi() {
        return this.api_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public String getPath() {
        return this.path_;
    }

    public void setOperation(String operation) {
        this.op_ = operation;
    }

    public String getOperation() {
        return this.op_;
    }

    public void setParams(Iterable<ParamData> params) {
        this.params_ = new ArrayList<ParamData>();
        if (params != null) {
            for (ParamData param : params) {
                this.addParam(param);
            }
        }
    }

    public Iterable<ParamData> getParams() {
        return this.params_;
    }

    public void addParam(ParamData param) {
        this.params_.add(DataValueChars.allowed(param));
    }

    public void setBody(MessageData body) {
        this.body_ = body;
    }

    public MessageData getBody() {
        return this.body_;
    }

    public void setAuthDefs(Iterable<AuthDef> authDefs) {
        this.authDefs_ = new ArrayList<AuthDef>();
        if (authDefs != null) {
            for (AuthDef authDef : authDefs) {
                this.addAuthDef(authDef);
            }
        }
    }

    public Iterable<AuthDef> getAuthDefs() {
        return this.authDefs_;
    }

    public void addAuthDef(AuthDef authDef) {
        this.authDefs_.add(authDef);
    }

    public void setInvalidInput(String invalidInput) {
        this.invalidInput_ = invalidInput;
    }

    public String getInvalidInput() {
        return this.invalidInput_;
    }

    public boolean isFailure() {
        return this.getInvalidInput() != null;
    }

    public void setAuthFailure(boolean authFailure) {
        this.authFailure_ = authFailure;
    }

    public boolean isAuthFailure() {
        return this.authFailure_;
    }

    @Override
    public int compareTo(RequestCase other) {
        return Comparator.comparing(RequestCase::getApi).thenComparing(RequestCase::getPath).thenComparing(RequestCase::getOperation).thenComparingInt(RequestCase::getId).compare(this, other);
    }

    public boolean equals(Object object) {
        RequestCase other = object instanceof RequestCase ? (RequestCase)object : null;
        return other != null && other.getId() == this.getId() && Objects.equals(other.getApi(), this.getApi()) && Objects.equals(other.getPath(), this.getPath()) && Objects.equals(other.getOperation(), this.getOperation());
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.getId() ^ Objects.hashCode(this.getApi()) ^ Objects.hashCode(this.getPath()) ^ Objects.hashCode(this.getOperation());
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append(this.getId()).append((Object)this.getName()).append((Object)this.getOperation()).append((Object)this.getPath()).append((Object)(this.isFailure() ? "FAILURE" : "SUCCESS")).toString();
    }

    private static class DataValueChars
    extends RequestCaseContext
    implements DataValueVisitor {
        private final ParamData param_;
        private final Characters chars_;

        public static ParamData allowed(ParamData param) {
            return new DataValueChars(param).allowed();
        }

        private DataValueChars(ParamData param) {
            this.param_ = param;
            this.chars_ = this.getParamCharacters(param);
        }

        private Characters getParamCharacters(ParamData param) {
            return OpenApiUtils.getParamCharacters(String.valueOf((Object)param.getLocation()).toLowerCase(), param.getStyle());
        }

        private ParamData allowed() {
            DataValue<?> value = this.param_.getValue();
            if (value != null) {
                this.doFor(String.valueOf(this.param_), () -> value.accept(this));
            }
            return this.param_;
        }

        @Override
        public void visit(ArrayValue<?> data) {
            IntStream.range(0, ((List)data.getValue()).size()).forEach(i -> this.doFor(String.format("item[%s]", i), () -> ((DataValue)((List)data.getValue()).get(i)).accept(this)));
        }

        @Override
        public void visit(BinaryValue data) {
        }

        @Override
        public void visit(BooleanValue data) {
        }

        @Override
        public void visit(DecimalValue data) {
        }

        @Override
        public void visit(IntegerValue data) {
        }

        @Override
        public void visit(LongValue data) {
        }

        @Override
        public void visit(NullValue data) {
        }

        @Override
        public void visit(ObjectValue data) {
            this.doFor("properties", () -> ((Map)data.getValue()).forEach((name, value) -> {
                if (!this.chars_.allowed((String)name)) {
                    throw new RequestCaseException(String.format("Property name='%s' is not allowed by %s", name, this.chars_));
                }
                this.doFor((String)name, () -> value.accept(this));
            }));
        }

        @Override
        public void visit(StringValue data) {
            if (!this.chars_.allowed((String)data.getValue())) {
                throw new RequestCaseException(String.format("Value='%s' is not allowed by %s", data.getValue(), this.chars_));
            }
        }
    }
}

