/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.AbstractStringDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;

public class PropertyNameDomain
extends AbstractStringDomain {
    public PropertyNameDomain() {
        this(1, 16);
    }

    public PropertyNameDomain(int minLength, int maxLength) {
        super(maxLength, new PropertyName());
        this.setLengthRange(minLength, maxLength);
    }

    public void setNameChars(String nameChars) {
        this.getPropertyName().setNameChars(nameChars);
    }

    public String getNameChars() {
        return this.getPropertyName().getNameChars();
    }

    @Override
    public boolean contains(String value) {
        return super.contains(value) && this.isName(value);
    }

    @Override
    protected String newValue(ResolverContext context, int length) {
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            value.append(this.getNameChars().charAt(context.getRandom().nextInt(this.getNameChars().length())));
        }
        return value.toString();
    }

    private PropertyName getPropertyName() {
        return (PropertyName)this.getCharacters();
    }

    private boolean isName(String value) {
        return this.getPropertyName().allowed(value);
    }

    public static class PropertyName
    extends Characters.Base {
        private String nameChars_ = "abcdefghijklmnopqrstuvwxyz";

        @Override
        public String getName() {
            return "PROPERTY_NAME";
        }

        public void setNameChars(String nameChars) {
            this.nameChars_ = nameChars;
        }

        public String getNameChars() {
            return this.nameChars_;
        }

        @Override
        public boolean allowed(char c) {
            return this.getNameChars().indexOf(c) >= 0;
        }
    }
}

