/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.AbstractStringDomain;
import org.cornutum.tcases.openapi.resolver.AbstractValueDomain;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.IntegerConstant;
import org.cornutum.tcases.openapi.resolver.MultiTypeDomain;
import org.cornutum.tcases.openapi.resolver.ObjectValue;
import org.cornutum.tcases.openapi.resolver.PropertyNameDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.ValueDomain;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;
import org.cornutum.tcases.util.ToString;

public class ObjectDomain
extends AbstractValueDomain<Map<String, DataValue<?>>> {
    private final Characters chars_;
    private Map<String, ValueDomain<?>> propertyDomains_;
    private ValueDomain<Integer> additionalPropertyCount_;
    private AbstractStringDomain additionalPropertyNames_;
    private ValueDomain<?> additionalPropertyValues_;

    public ObjectDomain() {
        this(null, null);
    }

    public ObjectDomain(Characters chars) {
        this(null, null, chars);
    }

    public ObjectDomain(ValueDomain<Integer> additionalPropertyCount, ValueDomain<?> additionalPropertyValues) {
        this(additionalPropertyCount, additionalPropertyValues, Characters.ANY);
    }

    public ObjectDomain(ValueDomain<Integer> additionalPropertyCount, ValueDomain<?> additionalPropertyValues, Characters chars) {
        this.chars_ = chars;
        this.setPropertyDomains(null);
        this.setAdditionalPropertyNames(null);
        this.setAdditionalPropertyCount(additionalPropertyCount);
        this.setAdditionalPropertyValues(additionalPropertyValues);
    }

    public Characters getCharacters() {
        return this.chars_;
    }

    public void setPropertyDomains(Map<String, ValueDomain<?>> propertyDomains) {
        this.propertyDomains_ = Optional.ofNullable(propertyDomains).orElse(new LinkedHashMap());
        this.propertyDomains_.keySet().stream().filter(name -> !this.getCharacters().allowed((String)name)).findFirst().ifPresent(name -> {
            throw new ValueDomainException(String.format("Property name='%s' is not allowed by %s", name, this.getCharacters()));
        });
    }

    public Map<String, ValueDomain<?>> getPropertyDomains() {
        return Collections.unmodifiableMap(this.propertyDomains_);
    }

    public void setAdditionalPropertyCount(ValueDomain<Integer> count) {
        this.additionalPropertyCount_ = count == null ? new IntegerConstant(0) : count;
    }

    public void setAdditionalPropertyValues(ValueDomain<?> additionalPropertyValues) {
        this.additionalPropertyValues_ = additionalPropertyValues == null ? new MultiTypeDomain(this.getCharacters(), DataValue.Type.any()) : additionalPropertyValues;
    }

    public ValueDomain<?> getAdditionalPropertyValues() {
        return this.additionalPropertyValues_;
    }

    public ValueDomain<Integer> getAdditionalPropertyCount() {
        return this.additionalPropertyCount_;
    }

    public void setAdditionalPropertyNames(AbstractStringDomain domain) {
        this.additionalPropertyNames_ = domain == null ? new PropertyNameDomain() : domain;
    }

    public AbstractStringDomain getAdditionalPropertyNames() {
        return this.additionalPropertyNames_;
    }

    @Override
    public Stream<DataValue<Map<String, DataValue<?>>>> values(ResolverContext context) {
        return Stream.generate(() -> this.dataValueOf(this.newObject(context)));
    }

    @Override
    protected DataValue<Map<String, DataValue<?>>> dataValueOf(Map<String, DataValue<?>> value) {
        return new ObjectValue(value);
    }

    private Map<String, DataValue<?>> newObject(ResolverContext context) {
        Map object = this.getPropertyDomains().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> context.resultFor((String)e.getKey(), () -> ((ValueDomain)e.getValue()).select(context)), (v1, v2) -> {
            throw new IllegalStateException("Duplicated object property name");
        }, LinkedHashMap::new));
        int totalPropertyCount = object.size() + context.resultFor("additionalPropertyCount", () -> this.getAdditionalPropertyCount().selectValue(context));
        while (object.size() < totalPropertyCount) {
            String additional;
            while (object.containsKey(additional = context.resultFor("additionalPropertyName", () -> (String)this.getAdditionalPropertyNames().selectValue(context)))) {
            }
            object.put(additional, context.resultFor("additionalPropertyValue", () -> this.getAdditionalPropertyValues().select(context)));
        }
        return object;
    }

    @Override
    public boolean contains(Map<String, DataValue<?>> value) {
        boolean containsProperties = this.getPropertyDomains().entrySet().stream().allMatch(e -> value.containsKey(e.getKey()) && ((ValueDomain)e.getValue()).contains((DataValue)value.get(e.getKey())));
        if (containsProperties) {
            Set additionalProperties = value.keySet().stream().filter(p -> !this.getPropertyDomains().containsKey(p)).collect(Collectors.toSet());
            containsProperties = this.getAdditionalPropertyCount().contains(additionalProperties.size()) && additionalProperties.stream().allMatch(p -> this.getAdditionalPropertyNames().contains((String)p) && this.getAdditionalPropertyValues().contains((DataValue)value.get(p)));
        }
        return containsProperties;
    }

    @Override
    public DataValue.Type[] getTypes() {
        return DataValue.Type.only(DataValue.Type.OBJECT);
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append("properties", this.getPropertyDomains().keySet()).append("additional", this.getAdditionalPropertyCount()).toString();
    }
}

