/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cornutum.tcases.VarBinding;
import org.cornutum.tcases.openapi.resolver.AbstractValueDomain;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;
import org.cornutum.tcases.util.ToString;

public abstract class NumberDomain<T extends Number>
extends AbstractValueDomain<T> {
    private final DataValue.Type type_;
    private final long maxRange_;
    private T min_;
    private T max_;
    private Set<T> excluded_;
    private T multipleOf_;
    private Set<T> notMultipleOfs_;
    private static final Pattern numberRangePattern_ = Pattern.compile("(Other)|(?:([<>]=?) )?(.*)");

    protected NumberDomain(DataValue.Type type, long maxRange) {
        this.type_ = type;
        this.maxRange_ = maxRange;
        this.setNotMultipleOfs((Set)null);
        this.setExcluded(null);
    }

    public long getMaxRange() {
        return this.maxRange_;
    }

    public abstract void setRange(Range var1);

    public abstract void setMultipleOf(String var1);

    public abstract void setNotMultipleOfs(String[] var1);

    protected abstract boolean isMultipleOf(T var1, T var2);

    public void setRange(T min, T max) {
        this.min_ = min;
        this.max_ = max;
    }

    public T getMin() {
        return this.min_;
    }

    public T getMax() {
        return this.max_;
    }

    public void setExcluded(Set<T> excluded) {
        this.excluded_ = Optional.ofNullable(excluded).orElse(Collections.emptySet());
    }

    public Set<T> getExcluded() {
        return this.excluded_;
    }

    public void setMultipleOf(T multipleOf) {
        this.multipleOf_ = multipleOf;
    }

    public T getMultipleOf() {
        return this.multipleOf_;
    }

    public void setNotMultipleOfs(Set<T> notMultipleOfs) {
        this.notMultipleOfs_ = notMultipleOfs == null ? new HashSet() : notMultipleOfs;
    }

    public Set<T> getNotMultipleOfs() {
        return this.notMultipleOfs_;
    }

    @Override
    public boolean contains(T value) {
        return value != null && ((Comparable)value).compareTo(this.getMin()) >= 0 && ((Comparable)value).compareTo(this.getMax()) <= 0 && this.isNotExcluded(value, this.getExcluded()) && Optional.ofNullable(this.getMultipleOf()).map(m -> this.isMultipleOf(value, m)).orElse(true) != false && this.isNotMultipleOf(value, this.getNotMultipleOfs());
    }

    @Override
    public DataValue.Type[] getTypes() {
        return DataValue.Type.only(this.type_);
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append(this.getMin()).append(this.getMax()).toString();
    }

    protected boolean isNotMultipleOf(T value, Set<T> multiples) {
        return multiples.stream().allMatch(m -> !this.isMultipleOf(value, m));
    }

    protected boolean isNotExcluded(T value, Set<T> excluded) {
        return excluded.stream().allMatch(e -> ((Comparable)((Object)value)).compareTo(e) != 0);
    }

    public static class Range {
        private final String min_;
        private final boolean minExclusive_;
        private final String max_;
        private final boolean maxExclusive_;
        private final Set<String> excluded_;

        public Range(String min, boolean minExclusive, String max, boolean maxExclusive, Set<String> excluded) {
            this.min_ = min;
            this.minExclusive_ = minExclusive;
            this.max_ = max;
            this.maxExclusive_ = maxExclusive;
            this.excluded_ = excluded;
        }

        public String getMin() {
            return this.min_;
        }

        public boolean isMinExclusive() {
            return this.minExclusive_;
        }

        public String getMax() {
            return this.max_;
        }

        public boolean isMaxExclusive() {
            return this.maxExclusive_;
        }

        public Set<String> getExcluded() {
            return this.excluded_;
        }

        public boolean isConstant() {
            return this.min_ != null && this.min_.equals(this.max_);
        }

        public static Range of(String op, String bound) {
            return Range.of(op, bound, null, Collections.emptySet());
        }

        public static Range of(VarBinding binding) {
            String rangeDef = String.valueOf(binding.getValue());
            Matcher matcher = numberRangePattern_.matcher(rangeDef);
            if (!matcher.matches()) {
                throw new ValueDomainException(String.format("Invalid number range='%s'", rangeDef));
            }
            Set<String> excluded = Optional.ofNullable(binding.getAnnotationList("excluded")).map(values -> values.stream().collect(Collectors.toSet())).orElse(Collections.emptySet());
            String rangeMin = binding.getAnnotation("rangeMin");
            String op = matcher.group(2);
            String bound = matcher.group(3);
            return Range.of(op, bound, rangeMin, excluded);
        }

        private static Range of(String op, String bound, String boundHint, Set<String> excluded) {
            String max;
            String min = op == null || op.startsWith(">") ? bound : null;
            String string = max = op == null || op.startsWith("<") ? bound : null;
            if (boundHint != null && max != null && min == null) {
                min = boundHint;
            }
            boolean minExclusive = ">".equals(op);
            boolean maxExclusive = "<".equals(op);
            return new Range(min, minExclusive, max, maxExclusive, excluded);
        }

        public String toString() {
            Optional<Set> excluded = this.getExcluded().isEmpty() ? Optional.empty() : Optional.of(this.getExcluded());
            return String.format("%s%s,%s%s%s", this.isMinExclusive() ? "(" : "[", String.valueOf(this.getMin()), String.valueOf(this.getMax()), this.isMaxExclusive() ? ")" : "]", excluded.map(e -> String.format("-[%s]", e.stream().collect(Collectors.joining(",")))).orElse(""));
        }
    }
}

