/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.AbstractValueDomain;
import org.cornutum.tcases.openapi.resolver.AsciiStringDomain;
import org.cornutum.tcases.openapi.resolver.BooleanConstant;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DecimalDomain;
import org.cornutum.tcases.openapi.resolver.IntegerDomain;
import org.cornutum.tcases.openapi.resolver.ObjectDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.ValueDomain;
import org.cornutum.tcases.util.ToString;

public class MultiTypeDomain
extends AbstractValueDomain<Object> {
    private final Characters chars_;
    private final List<ValueDomain<?>> typeDomains_;

    public MultiTypeDomain(DataValue.Type ... types) {
        this(Characters.ANY, types);
    }

    public MultiTypeDomain(Characters chars, DataValue.Type ... types) {
        this.chars_ = chars;
        this.typeDomains_ = Arrays.stream(types).map(this::getValueDomain).collect(Collectors.toList());
    }

    public Characters getCharacters() {
        return this.chars_;
    }

    @Override
    public Stream<DataValue<Object>> values(ResolverContext context) {
        return Stream.generate(() -> {
            ValueDomain<?> domain = this.typeDomains_.get(context.getRandom().nextInt(this.typeDomains_.size()));
            String type = String.valueOf((Object)domain.getTypes()[0]).toLowerCase();
            return context.resultFor(type, () -> domain.select(context));
        });
    }

    @Override
    protected DataValue<Object> dataValueOf(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object value) {
        return this.typeDomains_.stream().anyMatch(domain -> domain.containsObject(value));
    }

    @Override
    public DataValue.Type[] getTypes() {
        return (DataValue.Type[])this.typeDomains_.stream().map(domain -> domain.getTypes()[0]).toArray(DataValue.Type[]::new);
    }

    private ValueDomain<?> getValueDomain(DataValue.Type type) {
        return type == DataValue.Type.ARRAY ? this.getArrayDomain() : (type == DataValue.Type.BOOLEAN ? this.getBooleanDomain() : (type == DataValue.Type.INTEGER ? this.getIntegerDomain() : (type == DataValue.Type.NUMBER ? this.getNumberDomain() : (type == DataValue.Type.OBJECT ? this.getObjectDomain() : (type == DataValue.Type.STRING ? this.getStringDomain() : null)))));
    }

    private ValueDomain<?> getArrayDomain() {
        return this.getStringDomain().arrayOf(3, true);
    }

    private ValueDomain<?> getBooleanDomain() {
        return new BooleanConstant(true);
    }

    private ValueDomain<?> getIntegerDomain() {
        return new IntegerDomain(-1024, 1024);
    }

    private ValueDomain<?> getNumberDomain() {
        return new DecimalDomain(-1024.0, 1024.0);
    }

    private ValueDomain<?> getObjectDomain() {
        return new ObjectDomain(new IntegerDomain(0, 3), new MultiTypeDomain(this.getCharacters(), DataValue.Type.not(DataValue.Type.OBJECT)), this.getCharacters());
    }

    private ValueDomain<?> getStringDomain() {
        return new AsciiStringDomain(8, this.getCharacters());
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append((Object[])this.getTypes()).toString();
    }
}

