/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.util.ToString;

public class MessageData {
    private final DataValue<?> value_;
    private final String mediaType_;
    private final boolean valid_;

    public MessageData(DataValue<?> value, String mediaType, boolean valid) {
        this.value_ = value;
        this.mediaType_ = mediaType;
        this.valid_ = valid;
    }

    public DataValue<?> getValue() {
        return this.value_;
    }

    public DataValue.Type getType() {
        return Optional.ofNullable(this.getValue()).map(DataValue::getType).orElse(null);
    }

    public boolean isValid() {
        return this.valid_;
    }

    public String getMediaType() {
        return this.mediaType_;
    }

    public String toString() {
        ToStringBuilder builder = ToString.getBuilder((Object)this);
        if (!this.isValid()) {
            builder.append((Object)"FAILURE");
        }
        builder.append(this.getValue());
        Optional.ofNullable(this.getMediaType()).ifPresent(mediaType -> builder.append(mediaType));
        return builder.toString();
    }
}

