/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Collection;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.EnumDomain;
import org.cornutum.tcases.openapi.resolver.LongValue;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class LongEnum
extends EnumDomain<Long> {
    public LongEnum(Iterable<String> enums) {
        super(DataValue.Type.INTEGER, enums);
    }

    public LongEnum(Collection<Long> enums) {
        super(DataValue.Type.INTEGER, enums);
    }

    @Override
    protected Long valueOf(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (Exception e) {
            throw new ValueDomainException(String.format("Value=%s is not a valid long number", value), e);
        }
    }

    @Override
    protected DataValue<Long> dataValueOf(Long value) {
        return new LongValue(value);
    }
}

