/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.LongValue;
import org.cornutum.tcases.openapi.resolver.NumberDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;

public class LongDomain
extends NumberDomain<Long> {
    public LongDomain() {
        this(0x3FFFFFFFFFFFFFFFL);
    }

    public LongDomain(long maxRange) {
        super(DataValue.Type.INTEGER, maxRange);
    }

    public LongDomain(long min, long max) {
        this();
        this.setRange(min, max);
    }

    public LongDomain(NumberDomain.Range range) {
        this();
        this.setRange(range);
    }

    @Override
    public void setRange(NumberDomain.Range range) {
        Optional<NumberDomain.Range> ifRange = Optional.ofNullable(range);
        this.setExcluded(ifRange.map(NumberDomain.Range::getExcluded).orElse(Collections.emptySet()).stream().map(Long::valueOf).collect(Collectors.toSet()));
        this.setRange(Optional.ofNullable(ifRange.map(NumberDomain.Range::getMin).orElse(null)).map(Long::valueOf).map(i -> ifRange.map(NumberDomain.Range::isMinExclusive).orElse(false) != false ? i + 1L : i).orElse(-this.getMaxRange()), Optional.ofNullable(ifRange.map(NumberDomain.Range::getMax).orElse(null)).map(Long::valueOf).map(i -> ifRange.map(NumberDomain.Range::isMaxExclusive).orElse(false) != false ? i - 1L : i).orElse(this.getMaxRange()));
    }

    @Override
    public void setRange(Long min, Long max) {
        if (Long.signum(min) != Long.signum(max) && -Math.max(min, -9223372036854775807L) > Long.MAX_VALUE - max) {
            throw new IllegalArgumentException(String.format("Range=[%s,%s] exceeds maximum size=%s", min, max, Long.MAX_VALUE));
        }
        super.setRange(min, max);
    }

    @Override
    public void setMultipleOf(String multipleOf) {
        this.setMultipleOf((Number)Optional.ofNullable(multipleOf).map(Long::valueOf).orElse(null));
    }

    @Override
    public void setNotMultipleOfs(String[] notMultipleOfs) {
        this.setNotMultipleOfs(Arrays.stream(notMultipleOfs).map(Long::valueOf).collect(Collectors.toSet()));
    }

    @Override
    protected boolean isMultipleOf(Long value, Long multiple) {
        return value % multiple == 0L;
    }

    @Override
    public Stream<DataValue<Long>> values(ResolverContext context) {
        long firstMultiple;
        long multiple = Optional.ofNullable(this.getMultipleOf()).orElse(1L);
        long lastMultiple = (Long)this.getMax() / multiple * multiple;
        for (firstMultiple = (long)Math.ceil(((Long)this.getMin()).doubleValue() / (double)multiple) * multiple; !(firstMultiple > lastMultiple || this.isNotMultipleOf(firstMultiple, this.getNotMultipleOfs()) && this.isNotExcluded(firstMultiple, this.getExcluded())); firstMultiple += multiple) {
        }
        while (!(firstMultiple > lastMultiple || this.isNotMultipleOf(lastMultiple, this.getNotMultipleOfs()) && this.isNotExcluded(lastMultiple, this.getExcluded()))) {
            lastMultiple -= multiple;
        }
        long multiplesCount = lastMultiple / multiple - firstMultiple / multiple;
        long l = multiplesCount < Long.MAX_VALUE ? 1L : 0L;
        long originMultiple = firstMultiple;
        Stream<Long> longs = (multiplesCount += l) < 1L ? Stream.empty() : (multiplesCount == 1L ? Stream.of(Long.valueOf(firstMultiple)) : context.getRandom().longs(0L, multiplesCount).map(i -> originMultiple + i * multiple).filter(i -> this.isNotExcluded(i, this.getExcluded())).filter(i -> this.isNotMultipleOf(i, this.getNotMultipleOfs())).mapToObj(Long::new));
        return longs.map(this::dataValueOf);
    }

    @Override
    protected DataValue<Long> dataValueOf(Long value) {
        return new LongValue(value);
    }
}

