/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Optional;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.resolver.AbstractValueDomain;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.IntegerConstant;
import org.cornutum.tcases.openapi.resolver.IntegerDomain;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.ValueDomain;
import org.cornutum.tcases.util.ToString;

public class LengthDomain
extends AbstractValueDomain<Integer> {
    private final ValueDomain<Integer> valueDomain_;
    private final int min_;
    private final int max_;

    public LengthDomain(Integer length) {
        this.min_ = this.max_ = Optional.ofNullable(length).map(m -> Math.max(0, m)).orElse(0).intValue();
        this.valueDomain_ = new IntegerConstant(this.min_);
    }

    public LengthDomain(int min, int max) {
        this.min_ = min;
        this.max_ = max;
        this.valueDomain_ = new IntegerDomain(min, max);
    }

    public int getMin() {
        return this.min_;
    }

    public int getMax() {
        return this.max_;
    }

    @Override
    public Stream<DataValue<Integer>> values(ResolverContext context) {
        return this.valueDomain_.values(context);
    }

    @Override
    public boolean contains(Integer value) {
        return this.valueDomain_.contains(value);
    }

    @Override
    public DataValue.Type[] getTypes() {
        return this.valueDomain_.getTypes();
    }

    @Override
    protected DataValue<Integer> dataValueOf(Integer value) {
        return new IntegerValue(value);
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append(this.getMin()).append(this.getMax()).toString();
    }
}

