/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import org.cornutum.tcases.openapi.resolver.ArrayValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DataValues;
import org.cornutum.tcases.openapi.resolver.ObjectValue;
import org.cornutum.tcases.util.CollectionUtils;

public final class JsonNodes {
    private JsonNodes() {
    }

    public static ObjectValue toObjectValue(Object value) {
        try {
            return JsonNodes.toObjectValue((ObjectNode)ObjectNode.class.cast(value));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("value=%s is not an ObjectNode", value), e);
        }
    }

    public static ObjectValue toObjectValue(ObjectNode node) {
        try {
            return (ObjectValue)ObjectValue.class.cast(JsonNodes.toDataValue((JsonNode)node));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("node=%s does not represent an ObjectValue", node), e);
        }
    }

    public static ArrayValue<Object> toArrayValue(Object value) {
        try {
            return JsonNodes.toArrayValue((ArrayNode)ArrayNode.class.cast(value));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("value=%s is not an ArrayNode", value), e);
        }
    }

    public static ArrayValue<Object> toArrayValue(ArrayNode node) {
        try {
            return (ArrayValue)ArrayValue.class.cast(JsonNodes.toDataValue((JsonNode)node));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("node=%s does not represent an ArrayValue", node), e);
        }
    }

    public static DataValue<?> toDataValue(JsonNode node) {
        DataValue value;
        switch (node.getNodeType()) {
            case ARRAY: {
                value = DataValues.arrayOfAny(CollectionUtils.toStream((Iterator)node.elements()).map(e -> JsonNodes.toDataValue(e)).collect(Collectors.toList()));
                break;
            }
            case BOOLEAN: {
                value = DataValues.valueOf(node.asBoolean());
                break;
            }
            case NULL: {
                value = DataValues.nullValue();
                break;
            }
            case NUMBER: {
                value = node.canConvertToInt() ? DataValues.valueOf(node.asInt()) : (node.canConvertToLong() ? DataValues.valueOf(node.asLong()) : DataValues.valueOf(node.decimalValue()));
                break;
            }
            case OBJECT: {
                value = new ObjectValue(CollectionUtils.toStream((Iterator)node.fieldNames()).collect(Collectors.toMap(f -> f, f -> JsonNodes.toDataValue(node.get(f)), (v1, v2) -> v1, LinkedHashMap::new)));
                break;
            }
            case STRING: {
                value = DataValues.stringOf(node.asText());
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("%s is not a supported JsonNode type", node.getNodeType()));
            }
        }
        return value;
    }
}

