/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Collection;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.EnumDomain;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class IntegerEnum
extends EnumDomain<Integer> {
    public IntegerEnum(Iterable<String> enums) {
        super(DataValue.Type.INTEGER, enums);
    }

    public IntegerEnum(Collection<Integer> enums) {
        super(DataValue.Type.INTEGER, enums);
    }

    @Override
    protected Integer valueOf(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (Exception e) {
            throw new ValueDomainException(String.format("Value=%s is not a valid integer number", value), e);
        }
    }

    @Override
    protected DataValue<Integer> dataValueOf(Integer value) {
        return new IntegerValue(value);
    }
}

