/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.NumberDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;

public class IntegerDomain
extends NumberDomain<Integer> {
    public IntegerDomain() {
        this(0x3FFFFFFFL);
    }

    public IntegerDomain(long maxRange) {
        super(DataValue.Type.INTEGER, maxRange);
    }

    public IntegerDomain(int min, int max) {
        this();
        this.setRange(min, max);
    }

    public IntegerDomain(NumberDomain.Range range) {
        this();
        this.setRange(range);
    }

    @Override
    public void setRange(NumberDomain.Range range) {
        Optional<NumberDomain.Range> ifRange = Optional.ofNullable(range);
        this.setExcluded(ifRange.map(NumberDomain.Range::getExcluded).orElse(Collections.emptySet()).stream().map(Integer::valueOf).collect(Collectors.toSet()));
        this.setRange(Optional.ofNullable(ifRange.map(NumberDomain.Range::getMin).orElse(null)).map(Integer::valueOf).map(i -> ifRange.map(NumberDomain.Range::isMinExclusive).orElse(false) != false ? i + 1 : i).orElse((int)(-this.getMaxRange())), Optional.ofNullable(ifRange.map(NumberDomain.Range::getMax).orElse(null)).map(Integer::valueOf).map(i -> ifRange.map(NumberDomain.Range::isMaxExclusive).orElse(false) != false ? i - 1 : i).orElse((int)this.getMaxRange()));
    }

    @Override
    public void setRange(Integer min, Integer max) {
        if (Integer.signum(min) != Integer.signum(max) && -Math.max(min, -2147483647) > Integer.MAX_VALUE - max) {
            throw new IllegalArgumentException(String.format("Range=[%s,%s] exceeds maximum size=%s", min, max, Integer.MAX_VALUE));
        }
        super.setRange(min, max);
    }

    @Override
    public void setMultipleOf(String multipleOf) {
        this.setMultipleOf((Number)Optional.ofNullable(multipleOf).map(Integer::valueOf).orElse(null));
    }

    @Override
    public void setNotMultipleOfs(String[] notMultipleOfs) {
        this.setNotMultipleOfs(Arrays.stream(notMultipleOfs).map(Integer::valueOf).collect(Collectors.toSet()));
    }

    @Override
    protected boolean isMultipleOf(Integer value, Integer multiple) {
        return value % multiple == 0;
    }

    @Override
    public Stream<DataValue<Integer>> values(ResolverContext context) {
        int firstMultiple;
        int multiple = Optional.ofNullable(this.getMultipleOf()).orElse(1);
        int lastMultiple = (Integer)this.getMax() / multiple * multiple;
        for (firstMultiple = (int)Math.ceil(((Integer)this.getMin()).doubleValue() / (double)multiple) * multiple; !(firstMultiple > lastMultiple || this.isNotMultipleOf(firstMultiple, this.getNotMultipleOfs()) && this.isNotExcluded(firstMultiple, this.getExcluded())); firstMultiple += multiple) {
        }
        while (!(firstMultiple > lastMultiple || this.isNotMultipleOf(lastMultiple, this.getNotMultipleOfs()) && this.isNotExcluded(lastMultiple, this.getExcluded()))) {
            lastMultiple -= multiple;
        }
        int multiplesCount = lastMultiple / multiple - firstMultiple / multiple;
        int n = multiplesCount < Integer.MAX_VALUE ? 1 : 0;
        int originMultiple = firstMultiple;
        Stream<Integer> integers = (multiplesCount += n) < 1 ? Stream.empty() : (multiplesCount == 1 ? Stream.of(Integer.valueOf(firstMultiple)) : context.getRandom().ints(0, multiplesCount).map(i -> originMultiple + i * multiple).filter(i -> this.isNotExcluded(i, this.getExcluded())).filter(i -> this.isNotMultipleOf(i, this.getNotMultipleOfs())).mapToObj(Integer::new));
        return integers.map(this::dataValueOf);
    }

    @Override
    protected DataValue<Integer> dataValueOf(Integer value) {
        return new IntegerValue(value);
    }
}

