/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.resolver.AbstractValueDomain;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.util.CollectionUtils;
import org.cornutum.tcases.util.ToString;

public abstract class EnumDomain<T>
extends AbstractValueDomain<T> {
    private final DataValue.Type type_;
    private List<T> enums_;

    protected EnumDomain(DataValue.Type type, Iterable<String> enums) {
        this(type);
        super.setEnums(enums);
    }

    protected EnumDomain(DataValue.Type type, Collection<T> enums) {
        this(type);
        super.setEnums(enums.stream());
    }

    private EnumDomain(DataValue.Type type) {
        this.type_ = type;
    }

    public Iterable<T> getEnums() {
        return this.enums_;
    }

    private void setEnums(Iterable<String> enums) {
        this.setEnums(CollectionUtils.toStream(enums).map(this::valueOf));
    }

    private void setEnums(Stream<T> enums) {
        this.enums_ = enums.distinct().collect(Collectors.toList());
    }

    protected abstract T valueOf(String var1);

    @Override
    public Stream<DataValue<T>> values(ResolverContext context) {
        return Stream.generate(() -> this.dataValueOf(this.enums_.get(context.getRandom().nextInt(this.enums_.size()))));
    }

    @Override
    public boolean contains(T value) {
        return this.enums_.contains(value);
    }

    @Override
    public DataValue.Type[] getTypes() {
        return DataValue.Type.only(this.type_);
    }

    public String toString() {
        return ToString.getBuilder((Object)this).append(this.getEnums()).toString();
    }
}

