/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.EmailDomain;
import org.cornutum.tcases.openapi.resolver.EmailValue;
import org.cornutum.tcases.openapi.resolver.StringEnum;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;
import org.cornutum.tcases.util.CollectionUtils;

public class EmailEnum
extends StringEnum {
    public EmailEnum(Iterable<String> enums) {
        this(enums, Characters.ASCII);
    }

    public EmailEnum(Iterable<String> enums, Characters chars) {
        super(EmailEnum.assertEmails(enums), "email", chars);
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new EmailValue(value);
    }

    public static Iterable<String> assertEmails(Iterable<String> values) {
        CollectionUtils.toStream(values).filter(value -> !EmailDomain.isEmail(value)).findFirst().ifPresent(value -> {
            throw new ValueDomainException(String.format("Value=%s is not a valid email", value));
        });
        return values;
    }
}

