/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.OpenApiUtils;
import org.cornutum.tcases.openapi.resolver.AbstractStringDomain;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.EmailValue;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class EmailDomain
extends AbstractStringDomain {
    private final String allowedLocalPartChars_;
    private final String allowedDomainPartChars_;
    private static final int MIN_LENGTH = OpenApiUtils.stringFormatMin("email");
    private static final int MAX_LENGTH = OpenApiUtils.stringFormatMax("email");
    private static final int MAX_LOCAL = 64;
    private static final int MAX_DOMAIN = 255;
    private static final int MAX_LABEL = 63;
    private static final String alpha_ = "abcdefghijklmnopqrstuvwxyz";
    private static final String digits_ = "0123456789";
    private static final String special_ = "!#$%&'*+-/=?^_`{|}~;";
    private static final String localPartChars_ = "abcdefghijklmnopqrstuvwxyz" + "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "0123456789" + "!#$%&'*+-/=?^_`{|}~;";
    private static final String domainPartChars_ = "abcdefghijklmnopqrstuvwxyz" + "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "0123456789";
    private static final String[] topLevels_ = new String[]{"org", "com", "net", "edu", "gov"};

    public EmailDomain() {
        this(Characters.ASCII);
    }

    public EmailDomain(int maxLength) {
        this(maxLength, Characters.ASCII);
    }

    public EmailDomain(Characters chars) {
        super(MAX_LENGTH, chars);
        this.allowedLocalPartChars_ = chars.filtered(localPartChars_).orElseThrow(() -> new ValueDomainException(String.format("%s doesn't allow any of the required characters for the local part of an email addresss", chars)));
        this.allowedDomainPartChars_ = chars.filtered(domainPartChars_).orElseThrow(() -> new ValueDomainException(String.format("%s doesn't allow any of the required characters for the domain part of an email addresss", chars)));
    }

    public EmailDomain(int maxLength, Characters chars) {
        this(chars);
        this.setLengthRange(MIN_LENGTH, maxLength);
    }

    @Override
    protected void initLengthRange() {
        this.setLengthRange(MIN_LENGTH, this.getMaxLength());
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new EmailValue(value);
    }

    @Override
    public boolean contains(String value) {
        return super.contains(value) && EmailDomain.isEmail(value);
    }

    public static boolean isEmail(String value) {
        String[] parts = value.split("@", -1);
        String[] localParts = parts.length == 2 ? parts[0].split("\\.") : null;
        String[] domainParts = parts.length == 2 ? parts[1].split("\\.") : null;
        return Optional.ofNullable(localParts).filter(locals -> parts[0].length() > 0 && parts[0].length() <= 64).map(locals -> Arrays.stream(locals).allMatch(part -> EmailDomain.isStringOf(part, localPartChars_))).orElse(false) != false && Optional.ofNullable(domainParts).filter(domains -> parts[1].length() > 0 && parts[1].length() <= 255).map(labels -> Arrays.stream(labels).allMatch(part -> part.length() <= 63 && EmailDomain.isStringOf(part, domainPartChars_))).orElse(false) != false;
    }

    @Override
    protected String newValue(ResolverContext context, int length) {
        String value;
        if (length < MIN_LENGTH) {
            value = this.newValue(context, MIN_LENGTH).replace("@", "").substring(0, length);
        } else if (length > MAX_LENGTH) {
            value = StringUtils.rightPad((String)this.newValue(context, MAX_LENGTH), (int)length, (char)'@');
        } else {
            int partsLength = length - 5;
            int localLengthMax = Math.min(64, partsLength - 1);
            int localLengthMin = length - 255 - 1;
            int localLength = Math.max(context.getRandom().nextInt(localLengthMax) + 1, localLengthMin);
            int domainLength = partsLength - localLength;
            value = EmailDomain.randomPathOf(context, this.allowedLocalPartChars_, localLength, localLength) + "@" + EmailDomain.randomPathOf(context, this.allowedDomainPartChars_, domainLength, 63) + "." + topLevels_[context.getRandom().nextInt(topLevels_.length)];
        }
        return value;
    }

    private static String randomPathOf(ResolverContext context, String chars, int length, int maxPartLength) {
        int tailLength;
        double lengthd = length;
        int maxParts = (int)Math.floor((lengthd + 1.0) / 2.0);
        int minParts = (int)Math.ceil((lengthd + 1.0) / (double)(maxPartLength + 1));
        int parts = minParts + context.getRandom().nextInt(maxParts - minParts + 1);
        int partLength = (int)Math.ceil((lengthd - (double)parts + 1.0) / (double)parts);
        while ((tailLength = (parts - 1) * (partLength + 1)) >= length) {
            --parts;
        }
        int prefixLength = length - tailLength;
        return IntStream.range(0, parts).mapToObj(i -> EmailDomain.randomStringOf(context, chars, i == 0 ? prefixLength : partLength)).collect(Collectors.joining("."));
    }

    private static String randomStringOf(ResolverContext context, String chars, int length) {
        StringBuilder randomString = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            randomString.append(chars.charAt(context.getRandom().nextInt(chars.length())));
        }
        return randomString.toString();
    }

    private static boolean isStringOf(String value, String chars) {
        return IntStream.range(0, value.length()).map(i -> value.charAt(i)).allMatch(c -> chars.indexOf(c) >= 0);
    }
}

