/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import org.cornutum.tcases.openapi.Characters;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.EmailDomain;
import org.cornutum.tcases.openapi.resolver.EmailValue;
import org.cornutum.tcases.openapi.resolver.StringConstant;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class EmailConstant
extends StringConstant {
    public EmailConstant(String value) {
        this(value, Characters.ASCII);
    }

    public EmailConstant(String value, Characters chars) {
        super(EmailConstant.assertEmail(value), chars);
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new EmailValue(value);
    }

    public static String assertEmail(String value) {
        if (!EmailDomain.isEmail(value)) {
            throw new ValueDomainException(String.format("Value=%s is not a valid email", value));
        }
        return value;
    }
}

