/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.math.BigDecimal;
import java.util.Collection;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DecimalValue;
import org.cornutum.tcases.openapi.resolver.EnumDomain;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class DecimalEnum
extends EnumDomain<BigDecimal> {
    private final String format_;

    public DecimalEnum(Iterable<String> enums, String format) {
        super(DataValue.Type.NUMBER, enums);
        this.format_ = format;
    }

    public DecimalEnum(Collection<BigDecimal> enums, String format) {
        super(DataValue.Type.NUMBER, enums);
        this.format_ = format;
    }

    @Override
    protected BigDecimal valueOf(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (Exception e) {
            throw new ValueDomainException(String.format("Value=%s is not a valid decimal number", value), e);
        }
    }

    @Override
    protected DataValue<BigDecimal> dataValueOf(BigDecimal value) {
        return new DecimalValue(value, this.format_);
    }
}

