/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DecimalValue;
import org.cornutum.tcases.openapi.resolver.NumberDomain;
import org.cornutum.tcases.openapi.resolver.ResolverContext;

public class DecimalDomain
extends NumberDomain<BigDecimal> {
    private final String format_;
    private static final BigDecimal MAX_SIZE = new BigDecimal(Long.MAX_VALUE);

    public DecimalDomain() {
        this(null);
    }

    public DecimalDomain(String format) {
        this(MAX_SIZE.longValue() / 2L, format);
    }

    public DecimalDomain(long maxRange) {
        this(maxRange, null);
    }

    public DecimalDomain(long maxRange, String format) {
        super(DataValue.Type.NUMBER, maxRange);
        this.format_ = format;
    }

    public DecimalDomain(BigDecimal min, BigDecimal max) {
        this(min, max, null);
    }

    public DecimalDomain(BigDecimal min, BigDecimal max, String format) {
        this(format);
        this.setRange(min, max);
    }

    public DecimalDomain(double min, double max) {
        this(min, max, null);
    }

    public DecimalDomain(double min, double max, String format) {
        this(new BigDecimal(min), new BigDecimal(max), format);
    }

    public DecimalDomain(NumberDomain.Range range, String format) {
        this(format);
        this.setRange(range);
    }

    @Override
    public void setRange(NumberDomain.Range range) {
        Optional<NumberDomain.Range> ifRange = Optional.ofNullable(range);
        this.setExcluded(ifRange.map(NumberDomain.Range::getExcluded).orElse(Collections.emptySet()).stream().map(BigDecimal::new).collect(Collectors.toSet()));
        BigDecimal min = Optional.ofNullable(ifRange.map(NumberDomain.Range::getMin).orElse(null)).map(BigDecimal::new).orElse(new BigDecimal(-this.getMaxRange()));
        BigDecimal max = Optional.ofNullable(ifRange.map(NumberDomain.Range::getMax).orElse(null)).map(BigDecimal::new).orElse(new BigDecimal(this.getMaxRange()));
        int unitScale = Math.max(1, Math.max(min.scale(), max.scale()));
        BigDecimal unit = new BigDecimal(BigInteger.ONE, unitScale);
        this.setRange(ifRange.map(NumberDomain.Range::isMinExclusive).orElse(false) != false ? min.add(unit) : min, ifRange.map(NumberDomain.Range::isMaxExclusive).orElse(false) != false ? max.subtract(unit) : max);
    }

    @Override
    public void setRange(BigDecimal min, BigDecimal max) {
        if (max.subtract(min).compareTo(MAX_SIZE) > 0) {
            throw new IllegalArgumentException(String.format("Range=[%s,%s] exceeds maximum size=%s", min, max, MAX_SIZE));
        }
        super.setRange(min, max);
    }

    @Override
    public void setMultipleOf(String multipleOf) {
        this.setMultipleOf((Number)Optional.ofNullable(multipleOf).map(BigDecimal::new).orElse(null));
    }

    @Override
    public void setNotMultipleOfs(String[] notMultipleOfs) {
        this.setNotMultipleOfs(Arrays.stream(notMultipleOfs).map(BigDecimal::new).collect(Collectors.toSet()));
    }

    @Override
    protected boolean isMultipleOf(BigDecimal value, BigDecimal multiple) {
        return value.remainder(multiple).compareTo(BigDecimal.ZERO) == 0;
    }

    @Override
    public Stream<DataValue<BigDecimal>> values(ResolverContext context) {
        int unitScale = Math.max(Math.max(1, Optional.ofNullable(this.getMultipleOf()).map(BigDecimal::scale).orElse(0)), Math.max(((BigDecimal)this.getMin()).scale(), ((BigDecimal)this.getMax()).scale()));
        BigDecimal unit = new BigDecimal(BigInteger.ONE, unitScale);
        while (this.getNotMultipleOfs().contains(unit)) {
            unit = new BigDecimal(BigInteger.ONE, ++unitScale);
        }
        BigDecimal multiple = Optional.ofNullable(this.getMultipleOf()).orElse(unit);
        BigDecimal firstMultiple = this.divideCeiling((BigDecimal)this.getMin(), multiple).multiply(multiple);
        BigDecimal lastMultiple = this.divideFloor((BigDecimal)this.getMax(), multiple).multiply(multiple);
        while (!(firstMultiple.compareTo(lastMultiple) > 0 || this.isNotMultipleOf(firstMultiple, this.getNotMultipleOfs()) && this.isNotExcluded(firstMultiple, this.getExcluded()))) {
            firstMultiple = firstMultiple.add(multiple);
        }
        while (!(firstMultiple.compareTo(lastMultiple) > 0 || this.isNotMultipleOf(lastMultiple, this.getNotMultipleOfs()) && this.isNotExcluded(lastMultiple, this.getExcluded()))) {
            lastMultiple = lastMultiple.subtract(multiple);
        }
        long multiplesCount = this.divideFloor(lastMultiple.subtract(firstMultiple), multiple).add(BigDecimal.ONE).min(MAX_SIZE).longValue();
        BigDecimal originMultiple = firstMultiple;
        Stream<BigDecimal> decimals = multiplesCount < 1L ? Stream.empty() : (multiplesCount == 1L ? Stream.of(firstMultiple) : context.getRandom().longs(0L, multiplesCount).mapToObj(i -> originMultiple.add(multiple.multiply(new BigDecimal(i)))).filter(d -> this.isNotExcluded(d, this.getExcluded())).filter(d -> this.isNotMultipleOf(d, this.getNotMultipleOfs())));
        return decimals.map(this::dataValueOf);
    }

    @Override
    protected DataValue<BigDecimal> dataValueOf(BigDecimal value) {
        return new DecimalValue(value, this.format_);
    }

    private BigDecimal divideCeiling(BigDecimal value, BigDecimal divisor) {
        BigDecimal[] quotient = value.divideAndRemainder(divisor);
        return quotient[1].compareTo(BigDecimal.ZERO) == 0 ? quotient[0] : quotient[0].add(BigDecimal.ONE);
    }

    private BigDecimal divideFloor(BigDecimal value, BigDecimal divisor) {
        return value.divideToIntegralValue(divisor);
    }
}

