/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DateTimeConstant;
import org.cornutum.tcases.openapi.resolver.DateTimeValue;
import org.cornutum.tcases.openapi.resolver.StringEnum;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;
import org.cornutum.tcases.util.CollectionUtils;

public class DateTimeEnum
extends StringEnum {
    public DateTimeEnum(Iterable<String> enums) {
        super(DateTimeEnum.assertDateTimes(enums), "date-time");
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new DateTimeValue(value);
    }

    public static Iterable<String> assertDateTimes(Iterable<String> values) {
        CollectionUtils.toStream(values).filter(value -> !DateTimeConstant.isDateTime(value)).findFirst().ifPresent(value -> {
            throw new ValueDomainException(String.format("Value=%s is not a valid date-time", value));
        });
        return values;
    }
}

