/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Date;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.FormattedString;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DateTimeConstant;
import org.cornutum.tcases.openapi.resolver.DateTimeValue;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.TimeDomain;

public class DateTimeDomain
extends TimeDomain {
    public DateTimeDomain() {
        this(null, null);
    }

    public DateTimeDomain(Date minDate, Date maxDate) {
        super(30, minDate, maxDate);
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new DateTimeValue(value);
    }

    @Override
    protected void initLengthRange() {
        this.setLengthRange(29);
    }

    @Override
    protected boolean valuesEqual(String value1, String value2) {
        return DateTimeConstant.toTime(value1).equals(DateTimeConstant.toTime(value2));
    }

    @Override
    protected Stream<Date> timeValues(ResolverContext context) {
        long minTime = this.getMinDate().getTime();
        long maxTime = this.getMaxDate().getTime();
        long millis = maxTime - minTime + 1L;
        return millis < 1L ? Stream.empty() : (millis == 1L ? Stream.of(this.getMinDate()) : context.getRandom().longs(0L, millis).map(m -> minTime + m).mapToObj(Date::new));
    }

    @Override
    protected String assertValidTime(String value) {
        return DateTimeConstant.assertDateTime(value);
    }

    @Override
    protected boolean isValidTime(String value) {
        return DateTimeConstant.isDateTime(value);
    }

    @Override
    protected String format(Date time) {
        return FormattedString.getDateTimeFormat().format(time);
    }
}

