/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cornutum.tcases.openapi.FormattedString;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DateTimeValue;
import org.cornutum.tcases.openapi.resolver.StringConstant;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class DateTimeConstant
extends StringConstant {
    private static final String date_ = "([0-9]{4}-[0-9]{2}-[0-9]{2})";
    private static final String time_ = "([0-9]{2}:[0-9]{2}:[0-9]{2})";
    private static final String ms_ = "(\\.[0-9]{3})?";
    private static final String zone_ = "(Z|[+\\-][0-9]{2}:[0-9]{2})";
    private static final Pattern dateTime_ = Pattern.compile(String.format("%sT%s%s%s", "([0-9]{4}-[0-9]{2}-[0-9]{2})", "([0-9]{2}:[0-9]{2}:[0-9]{2})", "(\\.[0-9]{3})?", "(Z|[+\\-][0-9]{2}:[0-9]{2})"));

    public DateTimeConstant(String value) {
        super(DateTimeConstant.assertDateTime(value));
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new DateTimeValue(value);
    }

    public static Date toTime(String value) {
        try {
            return FormattedString.getDateTimeFormat().parse(value);
        }
        catch (Exception e) {
            throw new ValueDomainException(String.format("Value=%s is not a valid date-time", value));
        }
    }

    public static boolean isDateTime(String value) {
        try {
            Matcher dtm = dateTime_.matcher(value);
            return dtm.matches() && DateTimeConstant.toTime(DateTimeConstant.formatDateTime(dtm.group(1), dtm.group(2), dtm.group(3), dtm.group(4))) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String assertDateTime(String value) {
        if (!DateTimeConstant.isDateTime(value)) {
            throw new ValueDomainException(String.format("Value=%s is not a valid date-time", value));
        }
        return value;
    }

    private static String formatDateTime(String date, String time, String ms, String zone) {
        return String.format("%sT%s%s%s", date, time, ms == null ? ".000" : ms, zone.equals("Z") ? "+00:00" : zone);
    }
}

