/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DateConstant;
import org.cornutum.tcases.openapi.resolver.DateValue;
import org.cornutum.tcases.openapi.resolver.StringEnum;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;
import org.cornutum.tcases.util.CollectionUtils;

public class DateEnum
extends StringEnum {
    public DateEnum(Iterable<String> enums) {
        super(DateEnum.assertDates(enums), "date");
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new DateValue(value);
    }

    public static Iterable<String> assertDates(Iterable<String> values) {
        CollectionUtils.toStream(values).filter(value -> !DateConstant.isDate(value)).findFirst().ifPresent(value -> {
            throw new ValueDomainException(String.format("Value=%s is not a valid date", value));
        });
        return values;
    }
}

