/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.Calendar;
import java.util.Date;
import java.util.stream.Stream;
import org.cornutum.tcases.openapi.FormattedString;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DateConstant;
import org.cornutum.tcases.openapi.resolver.DateValue;
import org.cornutum.tcases.openapi.resolver.ResolverContext;
import org.cornutum.tcases.openapi.resolver.TimeDomain;

public class DateDomain
extends TimeDomain {
    public DateDomain() {
        this(null, null);
    }

    public DateDomain(Date minDate, Date maxDate) {
        super(11, minDate, maxDate);
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new DateValue(value);
    }

    @Override
    protected void initLengthRange() {
        this.setLengthRange(10);
    }

    @Override
    protected Stream<Date> timeValues(ResolverContext context) {
        long millisPerDay;
        Calendar minDate = new Calendar.Builder().setInstant(this.getMinDate()).build();
        long minTime = new Calendar.Builder().setDate(minDate.get(1), minDate.get(2), minDate.get(5)).setTimeOfDay(0, 0, 0, 0).build().getTimeInMillis();
        Calendar maxDate = new Calendar.Builder().setInstant(this.getMaxDate()).build();
        long maxTime = new Calendar.Builder().setDate(maxDate.get(1), maxDate.get(2), maxDate.get(5)).setTimeOfDay(0, 0, 0, 0).build().getTimeInMillis();
        long daysCount = (maxTime - minTime) / (millisPerDay = 86400000L) + 1L;
        return daysCount < 1L ? Stream.empty() : (daysCount == 1L ? Stream.of(this.getMinDate()) : context.getRandom().longs(0L, daysCount).map(d -> minTime + d * millisPerDay).mapToObj(Date::new));
    }

    @Override
    protected String assertValidTime(String value) {
        return DateConstant.assertDate(value);
    }

    @Override
    protected boolean isValidTime(String value) {
        return DateConstant.isDate(value);
    }

    @Override
    protected String format(Date time) {
        return FormattedString.getDateFormat().format(time);
    }
}

