/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.util.regex.Pattern;
import org.cornutum.tcases.openapi.FormattedString;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DateValue;
import org.cornutum.tcases.openapi.resolver.StringConstant;
import org.cornutum.tcases.openapi.resolver.ValueDomainException;

public class DateConstant
extends StringConstant {
    private static final Pattern date_ = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");

    public DateConstant(String value) {
        super(DateConstant.assertDate(value));
    }

    @Override
    protected DataValue<String> dataValueOf(String value) {
        return new DateValue(value);
    }

    public static boolean isDate(String value) {
        try {
            return date_.matcher(value).matches() && FormattedString.getDateFormat().parse(value) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String assertDate(String value) {
        if (!DateConstant.isDate(value)) {
            throw new ValueDomainException(String.format("Value=%s is not a valid date", value));
        }
        return value;
    }
}

