/*
 * Decompiled with CFR 0.152.
 */
package org.cornutum.tcases.openapi.resolver;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cornutum.tcases.openapi.resolver.ArrayValue;
import org.cornutum.tcases.openapi.resolver.Base64Value;
import org.cornutum.tcases.openapi.resolver.BinaryValue;
import org.cornutum.tcases.openapi.resolver.BooleanValue;
import org.cornutum.tcases.openapi.resolver.DataValue;
import org.cornutum.tcases.openapi.resolver.DateTimeValue;
import org.cornutum.tcases.openapi.resolver.DateValue;
import org.cornutum.tcases.openapi.resolver.DecimalValue;
import org.cornutum.tcases.openapi.resolver.EmailValue;
import org.cornutum.tcases.openapi.resolver.IntegerValue;
import org.cornutum.tcases.openapi.resolver.LongValue;
import org.cornutum.tcases.openapi.resolver.NullValue;
import org.cornutum.tcases.openapi.resolver.ObjectValue;
import org.cornutum.tcases.openapi.resolver.StringValue;
import org.cornutum.tcases.openapi.resolver.UuidValue;

public final class DataValues {
    private DataValues() {
    }

    @SafeVarargs
    public static <T> ArrayValue<T> arrayOf(DataValue<T> ... items) {
        return new ArrayValue<T>(Arrays.asList(items));
    }

    public static ArrayValue<Object> arrayOfAny(List<DataValue<?>> items) {
        List objects = items.stream().map(item -> item).collect(Collectors.toList());
        return new ArrayValue<Object>(objects);
    }

    public static BinaryValue valueOf(byte[] value) {
        return new BinaryValue(value);
    }

    public static BooleanValue valueOf(boolean value) {
        return new BooleanValue(value);
    }

    public static DecimalValue valueOf(BigDecimal value) {
        return new DecimalValue(value);
    }

    public static IntegerValue valueOf(int value) {
        return new IntegerValue(value);
    }

    public static LongValue valueOf(long value) {
        return new LongValue(value);
    }

    public static NullValue nullValue() {
        return new NullValue();
    }

    public static NullValue noValue() {
        return DataValues.nullValue();
    }

    public static ObjectValueBuilder object() {
        return new ObjectValueBuilder();
    }

    public static StringValue stringOf(String value) {
        return new StringValue(value);
    }

    public static Base64Value base64Of(String value) {
        return new Base64Value(value);
    }

    public static DateTimeValue dateTimeOf(String value) {
        return new DateTimeValue(value);
    }

    public static DateValue dateOf(String value) {
        return new DateValue(value);
    }

    public static EmailValue emailOf(String value) {
        return new EmailValue(value);
    }

    public static UuidValue uuidOf(String value) {
        return new UuidValue(value);
    }

    public static class ObjectValueBuilder {
        private Map<String, DataValue<?>> object_ = new LinkedHashMap();

        public ObjectValueBuilder with(String name, DataValue<?> value) {
            this.object_.put(name, value);
            return this;
        }

        public ObjectValue build() {
            return new ObjectValue(this.object_);
        }
    }
}

